/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBubbleColumn;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.utils.Utils;
import java.util.concurrent.ThreadLocalRandom;

public class BlockKelp
extends BlockFlowable {
    public BlockKelp() {
        this(0);
    }

    public BlockKelp(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Kelp";
    }

    @Override
    public int getId() {
        return 393;
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public double getResistance() {
        return 0.0;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.FLOW_INTO_BLOCK;
    }

    @Override
    public boolean canBeFlowedInto() {
        return this.level == null || !(this.level.getProvider() instanceof Anvil);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        int waterDamage;
        if (this.level != null && this.level.getProvider() instanceof Anvil) {
            Block down;
            if ((!(block instanceof BlockWater) || block.getDamage() != 0 && block.getDamage() < 8) && !(block instanceof BlockBubbleColumn) || (down = this.down()).getId() != this.getId() && down.isTransparent()) {
                return false;
            }
            this.setDamage(Utils.rand(1, 15));
            return this.getLevel().setBlock(this, this, true, true);
        }
        Block down = this.down();
        Block layer1Block = block.getLevelBlock(BlockLayer.WATERLOGGED);
        if ((down.getId() == 393 || down.isSolid()) && down.getId() != 213 && down.getId() != 79 && down.getId() != 88 && layer1Block instanceof BlockWater && ((waterDamage = block.getDamage()) == 0 || waterDamage == 8)) {
            if (waterDamage == 8) {
                this.getLevel().setBlock(this, BlockLayer.WATERLOGGED, Block.get(8), true, false);
            }
            if (down.getId() == 393 && down.getDamage() != 24) {
                down.setDamage(24);
                this.getLevel().setBlock(down, down, true, true);
            }
            this.setDamage(Utils.rand(1, 24));
            this.getLevel().setBlock(this, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (this.level != null && this.level.getProvider() instanceof Anvil) {
            Block up;
            if (type == 1) {
                Block down = this.down();
                if (down.getId() != this.getId() && down.isTransparent()) {
                    this.getLevel().useBreakOn(this);
                }
            } else if (type == 2 && this.getDamage() > 0 && ThreadLocalRandom.current().nextInt(100) < 14 && this.getDamage() < 15 && (up = this.up()) instanceof BlockWater && up.getDamage() == 0) {
                Block grown = Block.get(393, this.getDamage() + 1);
                BlockGrowEvent ev = new BlockGrowEvent(this, grown);
                Server.getInstance().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    this.level.setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, false, false);
                    this.getLevel().setBlock(up, ev.getNewState(), true, true);
                }
            }
            return type;
        }
        if (type == 1) {
            Block blockLayer1 = this.getLevelBlock(BlockLayer.WATERLOGGED);
            int waterDamage = 0;
            if (!(blockLayer1 instanceof BlockIceFrosted) && (!(blockLayer1 instanceof BlockWater) || (waterDamage = blockLayer1.getDamage()) != 0 && waterDamage != 8)) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            Block down = this.down();
            if (!down.isSolid() && down.getId() != 393 || down.getId() == 213 || down.getId() == 79 || down.getId() == 88) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            if (waterDamage == 8) {
                this.getLevel().setBlock(this, BlockLayer.WATERLOGGED, Block.get(8), true, false);
            }
            return type;
        }
        if (type == 2) {
            if (this.getDamage() > 0 && ThreadLocalRandom.current().nextInt(100) < 14) {
                this.grow();
            }
            return type;
        }
        return super.onUpdate(type);
    }

    public boolean grow() {
        Block up;
        int age = MathHelper.clamp(this.getDamage(), 0, 25);
        if (age < 25 && (up = this.up()) instanceof BlockWater && (up.getDamage() == 0 || up.getDamage() == 8)) {
            Block grown = Block.get(393, age + 1);
            BlockGrowEvent ev = new BlockGrowEvent(this, grown);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.setDamage(25);
                this.level.setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, false, false);
                this.getLevel().setBlock(up, BlockLayer.WATERLOGGED, Block.get(8), true, false);
                this.getLevel().setBlock(up, BlockLayer.NORMAL, ev.getNewState(), true, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        if (this.level != null && this.level.getProvider() instanceof Anvil) {
            return super.onBreak(item);
        }
        Block down = this.down();
        if (down.getId() == 393) {
            this.getLevel().setBlock(down, Block.get(393, ThreadLocalRandom.current().nextInt(25)), true, true);
        }
        this.getLevel().setBlock(this, Block.get(0), true, true);
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (this.level != null && this.level.getProvider() instanceof Anvil) {
            if (item.getId() == 351 && item.getDamage() == 15) {
                if (this.grow()) {
                    if (player != null && !player.isCreative()) {
                        --item.count;
                    }
                    this.level.addParticle(new BoneMealParticle(this));
                }
                return true;
            }
            return super.onActivate(item, player);
        }
        if (item.getId() != 351 || item.getDamage() != 15) {
            return false;
        }
        int x = (int)this.x;
        int z = (int)this.z;
        for (int y = (int)this.y + 1; y < 255; ++y) {
            BlockKelp highestKelp;
            int blockIdAbove = this.getLevel().getBlockIdAt(x, y, z);
            if (blockIdAbove == 393) continue;
            if (!Block.isWater(blockIdAbove)) {
                return false;
            }
            int waterData = this.getLevel().getBlockDataAt(x, y, z);
            if ((waterData == 0 || waterData == 8) && (highestKelp = (BlockKelp)this.getLevel().getBlock(x, y - 1, z)).grow()) {
                this.level.addParticle(new BoneMealParticle(this));
                if (player != null && (player.gamemode & 1) == 0) {
                    --item.count;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Item toItem() {
        return Item.get(335, (Integer)0, 1);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

