/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityJukebox;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemRecord;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.TextPacket;
import cn.nukkit.utils.BlockColor;

public class BlockJukebox
extends BlockSolid {
    @Override
    public String getName() {
        return "Jukebox";
    }

    @Override
    public int getId() {
        return 84;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (!(blockEntity instanceof BlockEntityJukebox)) {
            return false;
        }
        BlockEntityJukebox jukebox = (BlockEntityJukebox)blockEntity;
        if (jukebox.getRecordItem().getId() != 0) {
            jukebox.dropItem();
        } else if (item instanceof ItemRecord) {
            jukebox.setRecordItem(item);
            jukebox.play();
            if (player != null) {
                TextPacket pk = new TextPacket();
                pk.type = (byte)4;
                pk.message = "%record.nowPlaying";
                pk.parameters = new String[]{((ItemRecord)item).getDiscName()};
                pk.isLocalized = true;
                player.dataPacket(pk);
                --item.count;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (super.place(item, block, target, face, fx, fy, fz, player)) {
            CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", "Jukebox").putInt("x", this.getFloorX()).putInt("y", this.getFloorY()).putInt("z", this.getFloorZ());
            BlockEntity.createBlockEntity("Jukebox", this.getChunk(), nbt, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

