/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityItemFrame;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.Faceable;

public class BlockItemFrame
extends BlockTransparentMeta
implements Faceable {
    protected static final int[] FACING = new int[]{8, 9, 3, 2, 1, 0};

    public BlockItemFrame() {
        this(0);
    }

    public BlockItemFrame(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 199;
    }

    @Override
    public String getName() {
        return "Item Frame";
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && !this.getSide(this.getFacing()).isSolid()) {
            this.level.useBreakOn(this);
            return type;
        }
        return 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (!(blockEntity instanceof BlockEntityItemFrame)) {
            return false;
        }
        BlockEntityItemFrame itemFrame = (BlockEntityItemFrame)blockEntity;
        if (itemFrame.getItem() == null) {
            return true;
        }
        if (itemFrame.getItem().getId() == 0) {
            Item itemToFrame = item.clone();
            if (player != null && !player.isCreative()) {
                --item.count;
            }
            itemToFrame.setCount(1);
            itemFrame.setItem(itemToFrame);
            this.getLevel().addLevelEvent(this, 1040);
        } else {
            itemFrame.setItemRotation((itemFrame.getItemRotation() + 1) % 8);
            this.getLevel().addLevelEvent(this, 1044);
        }
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.isSolid() && (!block.isSolid() || block.canBeReplaced())) {
            this.setDamage(FACING[face.getIndex()]);
            this.getLevel().setBlock(this, this, true, true);
            CompoundTag nbt = new CompoundTag().putString("id", "ItemFrame").putInt("x", (int)block.x).putInt("y", (int)block.y).putInt("z", (int)block.z).putByte("ItemRotation", 0).putFloat("ItemDropChance", 1.0f);
            if (item.hasCustomBlockData()) {
                for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                    nbt.put(aTag.getName(), aTag);
                }
            }
            BlockEntity.createBlockEntity("ItemFrame", this.getChunk(), nbt, new Object[0]);
            this.getLevel().addLevelEvent(this, 1042);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        this.getLevel().setBlock(this, Block.get(0), true, true);
        this.getLevel().addLevelEvent(this, 1041);
        return true;
    }

    @Override
    public Item toItem() {
        return Item.get(389);
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityItemFrame) {
            return ((BlockEntityItemFrame)blockEntity).getAnalogOutput();
        }
        return super.getComparatorInputOverride();
    }

    public BlockFace getFacing() {
        switch (this.getDamage()) {
            case 0: 
            case 4: {
                return BlockFace.WEST;
            }
            case 1: 
            case 5: {
                return BlockFace.EAST;
            }
            case 2: 
            case 6: {
                return BlockFace.NORTH;
            }
            case 3: 
            case 7: {
                return BlockFace.SOUTH;
            }
            case 8: {
                return BlockFace.UP;
            }
            case 9: {
                return BlockFace.DOWN;
            }
        }
        return BlockFace.UP;
    }

    @Override
    public double getHardness() {
        return 0.25;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getFacing().getOpposite();
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

