/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;

public class BlockIceFrosted
extends BlockTransparentMeta {
    public BlockIceFrosted() {
        this(0);
    }

    public BlockIceFrosted(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 207;
    }

    @Override
    public String getName() {
        return "Frosted Ice";
    }

    @Override
    public double getResistance() {
        return 0.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getFrictionFactor() {
        return 0.98;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean success = super.place(item, block, target, face, fx, fy, fz, player);
        if (success) {
            this.level.scheduleUpdate(this, Utils.random.nextInt(20, 40));
        }
        return success;
    }

    @Override
    public boolean onBreak(Item item) {
        this.level.setBlock(this, BlockIceFrosted.get(8), true);
        return true;
    }

    @Override
    public int onUpdate(int type) {
        int time;
        if (type == 3) {
            int time2 = this.level.getTime() % 24000;
            if (!(time2 >= 13184 && time2 <= 22800 && this.getLevel().getBlockLightAt((int)this.x, (int)this.y, (int)this.z) < 12 || Utils.random.nextInt(3) != 0 && this.countNeighbors() >= 4)) {
                this.slightlyMelt(true);
            } else {
                this.level.scheduleUpdate(this, Utils.random.nextInt(20, 40));
            }
        } else if (type == 1) {
            if (this.countNeighbors() < 2) {
                this.level.setBlock(this, BlockIceFrosted.get(8), true);
            }
        } else if (!(type != 2 || (time = this.level.getTime() % 24000) >= 13184 && time <= 22800 && this.getLevel().getBlockLightAt((int)this.x, (int)this.y, (int)this.z) < 12 || Utils.random.nextInt(3) != 0 && this.countNeighbors() >= 4)) {
            this.slightlyMelt(true);
        }
        return super.onUpdate(type);
    }

    @Override
    public Item toItem() {
        return Item.get(0);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.ICE_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    protected void slightlyMelt(boolean isSource) {
        int age = this.getDamage();
        if (age < 3) {
            this.setDamage(age + 1);
            this.level.setBlock(this, this, true);
            this.level.scheduleUpdate(this.level.getBlock(this), Utils.random.nextInt(20, 40));
        } else {
            this.level.setBlock(this, BlockIceFrosted.get(8), true);
            if (isSource) {
                for (BlockFace face : BlockFace.values()) {
                    Block block = this.getSide(face);
                    if (!(block instanceof BlockIceFrosted)) continue;
                    ((BlockIceFrosted)block).slightlyMelt(false);
                }
            }
        }
    }

    private int countNeighbors() {
        int neighbors = 0;
        for (BlockFace face : BlockFace.values()) {
            if (this.getSide(face).getId() != 207 || ++neighbors < 4) continue;
            return neighbors;
        }
        return neighbors;
    }
}

