/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityHopper;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Faceable;

public class BlockHopper
extends BlockTransparentMeta
implements Faceable {
    public BlockHopper() {
        this(0);
    }

    public BlockHopper(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 154;
    }

    @Override
    public String getName() {
        return "Hopper Block";
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 24.0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        BlockFace facing = face.getOpposite();
        if (facing == BlockFace.UP) {
            facing = BlockFace.DOWN;
        }
        this.setDamage(facing.getIndex());
        boolean powered = this.level.isBlockPowered(this);
        if (powered == this.isEnabled()) {
            this.setEnabled(!powered);
        }
        this.getLevel().setBlock(this, this, true, true);
        CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", "Hopper").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        BlockEntity.createBlockEntity("Hopper", this.getChunk(), nbt, new Object[0]);
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityHopper) {
            player.addWindow(((BlockEntityHopper)blockEntity).getInventory());
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityHopper) {
            return ContainerInventory.calculateRedstone(((BlockEntityHopper)blockEntity).getInventory());
        }
        return super.getComparatorInputOverride();
    }

    public BlockFace getFacing() {
        return BlockFace.fromIndex(this.getDamage() & 7);
    }

    public boolean isEnabled() {
        return (this.getDamage() & 8) != 8;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            this.setDamage(this.getDamage() ^ 8);
        }
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            boolean powered = this.level.isBlockPowered(this);
            if (powered == this.isEnabled()) {
                this.setEnabled(!powered);
                this.level.setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, false, false);
            }
            return type;
        }
        return 0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return Item.get(410);
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

