/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.entity.Entity;
import cn.nukkit.math.Vector3;

public class BlockHoneyBlock
extends BlockSolid {
    @Override
    public String getName() {
        return "Honey Block";
    }

    @Override
    public int getId() {
        return 475;
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public double getResistance() {
        return 0.0;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (!entity.onGround && entity.motionY <= 0.08 && !(entity instanceof Player)) {
            double ex = Math.abs(this.x + 0.5 - entity.x);
            double ez = Math.abs(this.z + 0.5 - entity.z);
            double width = 0.4375 + (double)(entity.getWidth() / 2.0f);
            if (ex + 0.001 > width || ez + 0.001 > width) {
                Vector3 motion = entity.getMotion();
                motion.y = -0.05;
                if (entity.motionY < -0.13) {
                    double m4 = -0.05 / entity.motionY;
                    motion.x *= m4;
                    motion.z *= m4;
                }
                if (!entity.getMotion().equals(motion)) {
                    entity.setMotion(motion);
                }
                entity.resetFallDistance();
            }
        }
    }
}

