/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockGrindstone
extends BlockTransparentMeta
implements Faceable {
    public static final int TYPE_ATTACHMENT_STANDING = 0;
    public static final int TYPE_ATTACHMENT_HANGING = 1;
    public static final int TYPE_ATTACHMENT_SIDE = 2;
    public static final int TYPE_ATTACHMENT_MULTIPLE = 3;

    public BlockGrindstone() {
        this(0);
    }

    public BlockGrindstone(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Grindstone";
    }

    @Override
    public int getId() {
        return 450;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.IRON_BLOCK_COLOR;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 3);
    }

    public void setBlockFace(BlockFace face) {
        if (face.getHorizontalIndex() == -1) {
            return;
        }
        this.setDamage(this.getDamage() & 0x3C | face.getHorizontalIndex());
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(450));
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (block.getId() != 0 && block.canBeReplaced()) {
            face = BlockFace.UP;
        }
        switch (face) {
            case UP: {
                this.setAttachmentType(0);
                this.setBlockFace(player.getDirection().getOpposite());
                break;
            }
            case DOWN: {
                this.setAttachmentType(1);
                this.setBlockFace(player.getDirection().getOpposite());
                break;
            }
            default: {
                this.setBlockFace(face);
                this.setAttachmentType(2);
            }
        }
        if (!this.checkSupport()) {
            return false;
        }
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    public int getAttachmentType() {
        return (this.getDamage() & 0xC) >> 2 & 3;
    }

    public void setAttachmentType(int attachmentType) {
        this.setDamage(this.getDamage() & 0x33 | (attachmentType &= 3) << 2);
    }

    private boolean checkSupport() {
        switch (this.getAttachmentType()) {
            case 0: {
                if (this.down().getId() == 0) break;
                return true;
            }
            case 1: {
                if (this.up().getId() == 0) break;
                return true;
            }
            case 2: {
                BlockFace blockFace = this.getBlockFace();
                if (this.getSide(blockFace.getOpposite()).getId() == 0) break;
                return true;
            }
        }
        return false;
    }
}

