/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallable;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.level.generator.object.ObjectTallGrass;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;

public class BlockGravel
extends BlockFallable {
    @Override
    public int getId() {
        return 13;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public String getName() {
        return "Gravel";
    }

    @Override
    public Item[] getDrops(Item item) {
        if (Utils.random.nextInt(9) == 0 && !item.hasEnchantment(16)) {
            return new Item[]{Item.get(318)};
        }
        return new Item[]{this.toItem()};
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GRAY_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        Block up;
        if (player != null && item.getId() == 351 && item.getDamage() == 15 && (up = this.up()) instanceof BlockWater) {
            if (!player.isCreative()) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            if (up.getDamage() == 0 && up.up() instanceof BlockWater) {
                ObjectTallGrass.growSeagrass(this.getLevel(), this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }
}

