/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockDirt;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockUnknown;
import cn.nukkit.event.block.BlockSpreadEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.level.generator.object.ObjectTallGrass;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;

public class BlockGrass
extends BlockDirt {
    public BlockGrass() {
        this(0);
    }

    public BlockGrass(int meta) {
        super(0);
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public String getName() {
        return "Grass Block";
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        Block up;
        if (item.getId() == 351 && item.getDamage() == 15) {
            ObjectTallGrass.growGrass(this.getLevel(), this);
            this.level.addParticle(new BoneMealParticle(this));
            if (player != null && !player.isCreative()) {
                --item.count;
            }
            return true;
        }
        if (item.isHoe()) {
            Block up2 = this.up();
            if (up2 instanceof BlockAir || up2 instanceof BlockFlowable) {
                item.useOn(this);
                this.getLevel().setBlock(this, Block.get(60));
                if (player != null) {
                    player.getLevel().addSound(player, Sound.STEP_GRASS);
                }
                return true;
            }
        } else if (item.isShovel() && ((up = this.up()) instanceof BlockAir || up instanceof BlockFlowable)) {
            item.useOn(this);
            this.getLevel().setBlock(this, Block.get(198));
            if (player != null) {
                player.getLevel().addSound(player, Sound.STEP_GRASS);
            }
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            Block up = this.up();
            if (up instanceof BlockUnknown) {
                return 0;
            }
            if (up.isSolid() && !up.isTransparent() || up instanceof BlockLiquid) {
                BlockSpreadEvent ev = new BlockSpreadEvent(this, this, Block.get(3));
                Server.getInstance().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    this.getLevel().setBlock(this, ev.getNewState());
                }
                return 0;
            }
            int xx = Utils.rand((int)this.x - 1, (int)this.x + 1);
            int yy = Utils.rand((int)this.y - 2, (int)this.y + 2);
            int zz = Utils.rand((int)this.z - 1, (int)this.z + 1);
            Block block = this.getLevel().getBlock(xx, yy, zz);
            if (block.getId() == 3 && block.getDamage() == 0 && !(up = block.up()).isSolid() && up.isTransparent() && !(up instanceof BlockLiquid)) {
                BlockSpreadEvent ev = new BlockSpreadEvent(block, this, Block.get(2));
                Server.getInstance().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    this.getLevel().setBlock(block, ev.getNewState());
                }
            }
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GRASS_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public int getFullId() {
        return this.getId() << 6;
    }

    @Override
    public void setDamage(int meta) {
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.hasEnchantment(16)) {
            return new Item[]{this.toItem()};
        }
        return new Item[]{new ItemBlock(Block.get(3))};
    }
}

