/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityFlowerPot;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;

public class BlockFlowerPot
extends BlockFlowable {
    public BlockFlowerPot() {
        this(0);
    }

    public BlockFlowerPot(int meta) {
        super(meta);
    }

    private static boolean canPlaceIntoFlowerPot(Item item) {
        switch (item.getId()) {
            case 6: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 81: {
                return true;
            }
            case 31: {
                if (item.getDamage() != 2 && item.getDamage() != 3) break;
                return true;
            }
        }
        return false;
    }

    private static boolean canPlaceIntoFlowerPot(Block block) {
        if (block == null) {
            return false;
        }
        switch (block.getId()) {
            case 6: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 81: 
            case 418: 
            case 471: 
            case 478: 
            case 479: 
            case 483: 
            case 484: 
            case 729: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "Flower Pot";
    }

    @Override
    public int getId() {
        return 140;
    }

    private static boolean isSupportValid(Block block) {
        return block.isSolid() || block.isNarrowSurface() || Block.canStayOnFullSolid(block);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && !BlockFlowerPot.isSupportValid(this.down())) {
            this.level.useBreakOn(this);
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!BlockFlowerPot.isSupportValid(this.down())) {
            return false;
        }
        CompoundTag nbt = new CompoundTag().putString("id", "FlowerPot").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("item", 0).putInt("data", 0);
        if (item.hasCustomBlockData()) {
            for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                nbt.put(aTag.getName(), aTag);
            }
        }
        BlockEntity.createBlockEntity("FlowerPot", this.getChunk(), nbt, new Object[0]);
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        int itemID;
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (!(blockEntity instanceof BlockEntityFlowerPot)) {
            return false;
        }
        if (blockEntity.namedTag.getShort("item") != 0) {
            if (!BlockFlowerPot.canPlaceIntoFlowerPot(item) && !BlockFlowerPot.canPlaceIntoFlowerPot(item.getBlockUnsafe())) {
                int id = blockEntity.namedTag.getShort("item");
                if (id > 255) {
                    for (Item drop : player.getInventory().addItem(new ItemBlock(Block.get(id)))) {
                        player.dropItem(drop);
                    }
                } else {
                    for (Item drop : player.getInventory().addItem(Item.get(id, (Integer)blockEntity.namedTag.getInt("data")))) {
                        player.dropItem(drop);
                    }
                }
                blockEntity.namedTag.putShort("item", 0);
                blockEntity.namedTag.putInt("data", 0);
                blockEntity.setDirty();
                this.setDamage(0);
                this.level.setBlock(this, this, true);
                ((BlockEntityFlowerPot)blockEntity).spawnToAll();
                return true;
            }
            return false;
        }
        if (!BlockFlowerPot.canPlaceIntoFlowerPot(item)) {
            Block block = item.getBlockUnsafe();
            if (!BlockFlowerPot.canPlaceIntoFlowerPot(block)) {
                return true;
            }
            itemID = block.getId();
        } else {
            itemID = item.getId();
        }
        blockEntity.namedTag.putShort("item", itemID);
        blockEntity.namedTag.putInt("data", item.getDamage());
        blockEntity.setDirty();
        this.setDamage(1);
        this.getLevel().setBlock(this, this, true);
        ((BlockEntityFlowerPot)blockEntity).spawnToAll();
        if (!player.isCreative()) {
            --item.count;
        }
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        boolean dropInside = false;
        int insideID = 0;
        int insideMeta = 0;
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (blockEntity instanceof BlockEntityFlowerPot) {
            dropInside = true;
            insideID = blockEntity.namedTag.getShort("item");
            insideMeta = blockEntity.namedTag.getInt("data");
        }
        if (dropInside) {
            if (insideID > 255) {
                return new Item[]{Item.get(390), new ItemBlock(Block.get(insideID))};
            }
            return new Item[]{Item.get(390), Item.get(insideID, (Integer)insideMeta, 1)};
        }
        return new Item[]{Item.get(390)};
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    @Override
    public double getMinX() {
        return this.x + 0.3125;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.3125;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.6875;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.375;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.6875;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    public Item toItem() {
        return Item.get(390);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

