/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;

public class BlockFlower
extends BlockFlowable {
    public static final int TYPE_POPPY = 0;
    public static final int TYPE_BLUE_ORCHID = 1;
    public static final int TYPE_ALLIUM = 2;
    public static final int TYPE_AZURE_BLUET = 3;
    public static final int TYPE_RED_TULIP = 4;
    public static final int TYPE_ORANGE_TULIP = 5;
    public static final int TYPE_WHITE_TULIP = 6;
    public static final int TYPE_PINK_TULIP = 7;
    public static final int TYPE_OXEYE_DAISY = 8;
    public static final int TYPE_CORNFLOWER = 9;
    public static final int TYPE_LILY_OF_THE_VALLEY = 10;
    private static final String[] NAMES = new String[]{"Poppy", "Blue Orchid", "Allium", "Azure Bluet", "Red Tulip", "Orange Tulip", "White Tulip", "Pink Tulip", "Oxeye Daisy", "Cornflower", "Lily of the Valley", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown"};

    public BlockFlower() {
        this(0);
    }

    public BlockFlower(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 38;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() & 0xF];
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        int id = down.getId();
        if (id == 2 || id == 3 || id == 60 || id == 243 || id == 110 || id == 575) {
            this.getLevel().setBlock(block, this, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().isTransparent()) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == 15) {
            if (player != null && !player.isCreative()) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            for (int i = 0; i < 8; ++i) {
                Position vec = this.add(Utils.random.nextInt(-3, 4), Utils.random.nextInt(-1, 2), Utils.random.nextInt(-3, 4));
                if (!(vec.getY() >= (double)this.level.getMinBlockY()) || !(vec.getY() <= (double)this.level.getMaxBlockY()) || this.level.getBlock(vec).getId() != 0 || this.level.getBlock(vec.down()).getId() != 2) continue;
                if ((this.getDamage() == 38 || this.getDamage() == 37) && Utils.random.nextInt(10) == 0) {
                    this.level.setBlock(vec, this.getUncommonFlower(), true);
                    continue;
                }
                this.level.setBlock(vec, BlockFlower.get(this.getId(), this.getDamage()), true);
            }
            return true;
        }
        return false;
    }

    protected Block getUncommonFlower() {
        return BlockFlower.get(37);
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

