/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAnvil;
import cn.nukkit.block.BlockBeacon;
import cn.nukkit.block.BlockBrewingStand;
import cn.nukkit.block.BlockCactus;
import cn.nukkit.block.BlockCake;
import cn.nukkit.block.BlockCampfire;
import cn.nukkit.block.BlockChest;
import cn.nukkit.block.BlockDaylightDetector;
import cn.nukkit.block.BlockEnchantingTable;
import cn.nukkit.block.BlockEnderChest;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockGlass;
import cn.nukkit.block.BlockHopper;
import cn.nukkit.block.BlockIce;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockShulkerBox;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.block.BlockSnowLayer;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockTNT;
import cn.nukkit.entity.BaseEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.item.EntityPotion;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.event.block.BlockBurnEvent;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.event.block.BlockIgniteEvent;
import cn.nukkit.event.entity.EntityCombustByBlockEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;

public class BlockFire
extends BlockFlowable {
    public BlockFire() {
        this(0);
    }

    public BlockFire(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 51;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public String getName() {
        return "Fire Block";
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (entity instanceof EntityPotion && ((EntityPotion)entity).potionId == 0) {
            BlockFadeEvent event = new BlockFadeEvent(this, Block.get(0));
            this.level.getServer().getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                this.level.setBlock(this, event.getNewState(), true);
            }
            return;
        }
        if (!(entity.fireProof && entity.isOnFire() && entity instanceof BaseEntity)) {
            if (!(entity instanceof EntityLiving) || !entity.hasEffect(12) && this.level.getGameRules().getBoolean(GameRule.FIRE_DAMAGE)) {
                entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.FIRE, 1.0f));
            }
            if (!entity.fireProof || !entity.isOnFire()) {
                EntityCombustByBlockEvent ev = new EntityCombustByBlockEvent(this, entity, 8);
                if (entity instanceof EntityArrow) {
                    ev.setCancelled();
                }
                Server.getInstance().getPluginManager().callEvent(ev);
                if (!ev.isCancelled() && entity.isAlive() && entity.noDamageTicks == 0) {
                    entity.setOnFire(ev.getDuration());
                }
            }
        }
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[0];
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 || type == 2) {
            if (!this.isBlockTopFacingSurfaceSolid(this.down()) && !this.canNeighborBurn()) {
                this.getLevel().setBlock(this, Block.get(0), true);
            } else if (this.level.gameRules.getBoolean(GameRule.DO_FIRE_TICK) && !this.level.isUpdateScheduled(this, this)) {
                this.level.scheduleUpdate(this, this.tickRate());
            }
            return 1;
        }
        if (type == 3 && this.level.gameRules.getBoolean(GameRule.DO_FIRE_TICK)) {
            boolean forever;
            Block down = this.down();
            boolean bl = forever = this.getId() == 492 || down.getId() == 87 || down.getId() == 213 || down.getId() == 7 && this.level.getDimension() == 2;
            if (!forever && this.getLevel().isRaining() && (this.getLevel().canBlockSeeSky(this) || this.getLevel().canBlockSeeSky(this.east()) || this.getLevel().canBlockSeeSky(this.west()) || this.getLevel().canBlockSeeSky(this.south()) || this.getLevel().canBlockSeeSky(this.north()))) {
                this.getLevel().setBlock(this, Block.get(0), true);
            }
            if (!this.isBlockTopFacingSurfaceSolid(down) && !this.canNeighborBurn()) {
                this.getLevel().setBlock(this, Block.get(0), true);
                return 0;
            }
            int meta = this.getDamage();
            if (meta < 15) {
                int newMeta = meta + Utils.random.nextInt(3);
                if (newMeta > 15) {
                    newMeta = 15;
                }
                this.setDamage(newMeta);
                this.getLevel().setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, true, false);
            }
            this.getLevel().scheduleUpdate(this, this.tickRate() + Utils.random.nextInt(10));
            if (!forever && !this.canNeighborBurn()) {
                if (!this.isBlockTopFacingSurfaceSolid(this.down()) || meta > 3) {
                    this.getLevel().setBlock(this, Block.get(0), true);
                }
            } else if (!forever && this.down().getBurnAbility() <= 0 && meta == 15 && Utils.random.nextInt(4) == 0) {
                this.getLevel().setBlock(this, Block.get(0), true);
            } else {
                int o = 0;
                this.tryToCatchBlockOnFire(this.getSideIfLoaded(BlockFace.EAST), 300 + o, meta);
                this.tryToCatchBlockOnFire(this.getSideIfLoaded(BlockFace.WEST), 300 + o, meta);
                this.tryToCatchBlockOnFire(this.getSideIfLoaded(BlockFace.DOWN), 250 + o, meta);
                this.tryToCatchBlockOnFire(this.getSideIfLoaded(BlockFace.UP), 250 + o, meta);
                this.tryToCatchBlockOnFire(this.getSideIfLoaded(BlockFace.SOUTH), 300 + o, meta);
                this.tryToCatchBlockOnFire(this.getSideIfLoaded(BlockFace.NORTH), 300 + o, meta);
                int dif = 40 + this.getLevel().getServer().getDifficulty() * 7;
                for (int x = (int)(this.x - 1.0); x <= (int)(this.x + 1.0); ++x) {
                    for (int z = (int)(this.z - 1.0); z <= (int)(this.z + 1.0); ++z) {
                        for (int y = (int)(this.y - 1.0); y <= (int)(this.y + 4.0); ++y) {
                            int t2;
                            Block block;
                            int chance;
                            BaseFullChunk chunk;
                            if (x == (int)this.x && y == (int)this.y && z == (int)this.z) continue;
                            int k = 100;
                            if ((double)y > this.y + 1.0) {
                                k = (int)((double)k + ((double)y - (this.y + 1.0)) * 100.0);
                            }
                            if ((chunk = this.getLevel().getChunkIfLoaded(x >> 4, z >> 4)) == null || (chance = BlockFire.getChanceOfNeighborsEncouragingFire(block = this.getLevel().getBlock(chunk, x, y, z, false))) <= 0 || (t2 = (chance + dif) / (meta + 30)) <= 0 || Utils.random.nextInt(k) > t2) continue;
                            int damage = meta + (Utils.random.nextInt(5) >> 2);
                            if (damage > 15) {
                                damage = 15;
                            }
                            BlockIgniteEvent e = new BlockIgniteEvent(block, this, null, BlockIgniteEvent.BlockIgniteCause.SPREAD);
                            this.level.getServer().getPluginManager().callEvent(e);
                            if (e.isCancelled()) continue;
                            this.getLevel().setBlock(block, Block.get(51, damage), true);
                            this.getLevel().scheduleUpdate(block, this.tickRate());
                        }
                    }
                }
            }
        }
        return 0;
    }

    private void tryToCatchBlockOnFire(Block block, int bound, int damage) {
        int burnAbility = block.getBurnAbility();
        if (burnAbility == 0) {
            return;
        }
        if (Utils.random.nextInt(bound) < burnAbility) {
            if (Utils.random.nextInt(damage + 10) < 5) {
                int meta = damage + (Utils.random.nextInt(5) >> 2);
                if (meta > 15) {
                    meta = 15;
                }
                BlockIgniteEvent e = new BlockIgniteEvent(block, this, null, BlockIgniteEvent.BlockIgniteCause.SPREAD);
                this.level.getServer().getPluginManager().callEvent(e);
                if (!e.isCancelled()) {
                    this.getLevel().setBlock(block, Block.get(51, meta), true);
                    this.getLevel().scheduleUpdate(block, this.tickRate());
                }
            } else {
                BlockBurnEvent ev = new BlockBurnEvent(block);
                this.getLevel().getServer().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    this.getLevel().setBlock(block, Block.get(0), true);
                }
            }
            if (block instanceof BlockTNT) {
                ((BlockTNT)block).prime();
            }
        }
    }

    private static int getChanceOfNeighborsEncouragingFire(Block block) {
        if (block.getId() != 0) {
            return 0;
        }
        int chance = 0;
        chance = Math.max(chance, block.getSideIfLoaded(BlockFace.EAST).getBurnChance());
        chance = Math.max(chance, block.getSideIfLoaded(BlockFace.WEST).getBurnChance());
        chance = Math.max(chance, block.getSideIfLoaded(BlockFace.DOWN).getBurnChance());
        chance = Math.max(chance, block.getSideIfLoaded(BlockFace.UP).getBurnChance());
        chance = Math.max(chance, block.getSideIfLoaded(BlockFace.SOUTH).getBurnChance());
        chance = Math.max(chance, block.getSideIfLoaded(BlockFace.NORTH).getBurnChance());
        return chance;
    }

    public boolean canNeighborBurn() {
        for (BlockFace face : BlockFace.values()) {
            if (this.getSide(face).getBurnChance() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockTopFacingSurfaceSolid(Block block) {
        if (block != null) {
            if (block instanceof BlockStairs && (block.getDamage() & 4) == 4) {
                return true;
            }
            if (block instanceof BlockSlab && (this.getDamage() & 8) > 0) {
                return true;
            }
            if (block instanceof BlockSnowLayer && (block.getDamage() & 7) == 7) {
                return true;
            }
            if (block instanceof BlockGlass) {
                return false;
            }
            if (block instanceof BlockHopper || block instanceof BlockBeacon) {
                return false;
            }
            if (block instanceof BlockShulkerBox || block instanceof BlockChest || block instanceof BlockEnderChest) {
                return false;
            }
            if (block instanceof BlockAnvil || block instanceof BlockEnchantingTable || block instanceof BlockBrewingStand) {
                return false;
            }
            if (block instanceof BlockCampfire) {
                return false;
            }
            if (block instanceof BlockCactus) {
                return false;
            }
            if (block instanceof BlockDaylightDetector) {
                return false;
            }
            if (block instanceof BlockIce) {
                return false;
            }
            if (block instanceof BlockCake) {
                return false;
            }
            return block.isSolid();
        }
        return false;
    }

    @Override
    public int tickRate() {
        return 30;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return this;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(0));
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

