/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFenceGate;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.utils.BlockColor;

public class BlockFence
extends BlockTransparentMeta {
    public static final int FENCE_OAK = 0;
    public static final int FENCE_SPRUCE = 1;
    public static final int FENCE_BIRCH = 2;
    public static final int FENCE_JUNGLE = 3;
    public static final int FENCE_ACACIA = 4;
    public static final int FENCE_DARK_OAK = 5;
    private static final String[] NAMES = new String[]{"Oak Fence", "Spruce Fence", "Birch Fence", "Jungle Fence", "Acacia Fence", "Dark Oak Fence", "", ""};

    public BlockFence() {
        this(0);
    }

    public BlockFence(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 85;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() & 7];
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        boolean north = this.canConnect(this.north());
        boolean south = this.canConnect(this.south());
        boolean west = this.canConnect(this.west());
        boolean east = this.canConnect(this.east());
        double n = north ? 0.0 : 0.375;
        double s2 = south ? 1.0 : 0.625;
        double w = west ? 0.0 : 0.375;
        double e = east ? 1.0 : 0.625;
        return new SimpleAxisAlignedBB(this.x + w, this.y, this.z + n, this.x + e, this.y + 1.5, this.z + s2);
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 20;
    }

    public boolean canConnect(Block block) {
        return block instanceof BlockFence || block instanceof BlockFenceGate || block.isSolid() && !block.isTransparent();
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 7) {
            default: {
                return BlockColor.WOOD_BLOCK_COLOR;
            }
            case 1: {
                return BlockColor.SPRUCE_BLOCK_COLOR;
            }
            case 2: {
                return BlockColor.SAND_BLOCK_COLOR;
            }
            case 3: {
                return BlockColor.DIRT_BLOCK_COLOR;
            }
            case 4: {
                return BlockColor.ORANGE_BLOCK_COLOR;
            }
            case 5: 
        }
        return BlockColor.BROWN_BLOCK_COLOR;
    }

    @Override
    public Item toItem() {
        return new ItemBlock((Block)this, this.getDamage());
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }
}

