/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCrops;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.utils.BlockColor;

public class BlockFarmland
extends BlockTransparentMeta {
    public BlockFarmland() {
        this(0);
    }

    public BlockFarmland(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Farmland";
    }

    @Override
    public int getId() {
        return 60;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.9375;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            Block block;
            Block up = this.up();
            if (up.isSolid()) {
                this.level.setBlock(this, Block.get(3), false, true);
                return 2;
            }
            boolean found = false;
            boolean unloadedChunk = false;
            if (this.level.isRaining()) {
                found = true;
            } else {
                int x = (int)this.x - 4;
                while ((double)x <= this.x + 4.0) {
                    int z = (int)this.z - 4;
                    while ((double)z <= this.z + 4.0) {
                        int y = (int)this.y;
                        while ((double)y <= this.y + 1.0) {
                            if ((double)z != this.z || (double)x != this.x || (double)y != this.y) {
                                BaseFullChunk chunk = this.level.getChunkIfLoaded(x >> 4, z >> 4);
                                if (chunk == null) {
                                    unloadedChunk = true;
                                } else {
                                    int block2 = this.level.getBlockIdAt(chunk, x, y, z);
                                    if (Block.isWater(block2) || block2 == 207 || this.level.isBlockWaterloggedAt(chunk, x, y, z)) {
                                        found = true;
                                        break;
                                    }
                                }
                            }
                            ++y;
                        }
                        ++z;
                    }
                    ++x;
                }
            }
            if (!found && unloadedChunk) {
                return 0;
            }
            if (found || (block = this.down()) instanceof BlockWater || block instanceof BlockIceFrosted) {
                if (this.getDamage() < 7) {
                    this.setDamage(7);
                    this.level.setBlock(this, this, false, true);
                }
                return 2;
            }
            if (this.getDamage() > 0) {
                this.setDamage(this.getDamage() - 1);
                this.level.setBlock(this, this, false, true);
            } else if (!(up instanceof BlockCrops)) {
                this.level.setBlock(this, Block.get(3), false, true);
            }
            return 2;
        }
        if (type == 1 && this.up().isSolid()) {
            this.level.setBlock(this, Block.get(3), false, true);
            return 1;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(3));
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.DIRT_BLOCK_COLOR;
    }
}

