/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockEndPortalFrame
extends BlockTransparentMeta
implements Faceable {
    private static final int[] FACES = new int[]{2, 3, 0, 1};

    public BlockEndPortalFrame() {
        this(0);
    }

    public BlockEndPortalFrame(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 120;
    }

    @Override
    public double getResistance() {
        return 1.8E7;
    }

    @Override
    public double getHardness() {
        return -1.0;
    }

    @Override
    public int getLightLevel() {
        return 1;
    }

    @Override
    public String getName() {
        return "End Portal Frame";
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public double getMaxY() {
        return this.y + ((this.getDamage() & 4) > 0 ? 1.0 : 0.8125);
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return (this.getDamage() & 4) != 0 ? 15 : 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if ((this.getDamage() & 4) == 0 && player != null && item.getId() == 381 && !player.sneakToBlockInteract()) {
            this.setDamage(this.getDamage() + 4);
            this.getLevel().setBlock(this, this, true, false);
            this.getLevel().addLevelSoundEvent(this, 173);
            for (int i = 0; i < 4; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    Block t2 = this.getSide(BlockFace.fromHorizontalIndex(i), 2).getSide(BlockFace.fromHorizontalIndex((i + 1) % 4), j);
                    if (!BlockEndPortalFrame.isCompletedPortal(t2)) continue;
                    for (int k = -1; k <= 1; ++k) {
                        for (int l = -1; l <= 1; ++l) {
                            this.getLevel().setBlock(t2.add(k, 0.0, l), Block.get(119), true);
                        }
                    }
                    this.getLevel().addLevelSoundEvent(this, 174);
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setDamage(FACES[player != null ? player.getDirection().getHorizontalIndex() : 0]);
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    private static boolean isCompletedPortal(Block center) {
        for (int i = 0; i < 4; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Block block = center.getSide(BlockFace.fromHorizontalIndex(i), 2).getSide(BlockFace.fromHorizontalIndex((i + 1) % 4), j);
                if (block.getId() == 120 && (block.getDamage() & 4) != 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GREEN_BLOCK_COLOR;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }
}

