/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDripleafBig;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.custom.properties.BlockProperties;
import cn.nukkit.block.properties.BlockPropertiesHelper;
import cn.nukkit.block.properties.VanillaProperties;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.Faceable;

public class BlockDripleafSmall
extends BlockFlowable
implements BlockPropertiesHelper,
Faceable {
    private static final BlockProperties PROPERTIES = new BlockProperties(VanillaProperties.UPPER_BLOCK, VanillaProperties.DIRECTION);

    public BlockDripleafSmall() {
        this(0);
    }

    public BlockDripleafSmall(int meta) {
        super(meta);
    }

    @Override
    public BlockProperties getBlockProperties() {
        return PROPERTIES;
    }

    @Override
    public boolean canPlaceOn(Block floor, Position pos) {
        switch (floor.getId()) {
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 60: 
            case 82: 
            case 110: 
            case 575: 
            case 591: {
                return super.canPlaceOn(floor, pos);
            }
        }
        if (floor.getLayer() == LAYER_WATERLOGGED && floor.getId() == 0) {
            return super.canPlaceOn(floor, pos);
        }
        return false;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = block.down();
        if (!this.canPlaceOn(down, target)) {
            return false;
        }
        if (down.getId() == 591) {
            BlockDripleafSmall floor = (BlockDripleafSmall)down;
            floor.setHasHead(false);
            this.getLevel().setBlock(floor, floor, true, true);
            this.setDirection(floor.getDirection());
        } else {
            this.setDirection(player.getDirection().getOpposite());
        }
        this.setHasHead(true);
        return this.getLevel().setBlock(this, this, true, true);
    }

    @Override
    public boolean onBreak(Item item, Player player) {
        Block down = this.down();
        while (down instanceof BlockDripleafSmall) {
            this.getLevel().setBlock(down, Block.get(0), true, true);
            this.getLevel().addParticle(new DestroyBlockParticle(down.add(0.5), down));
            down = down.down();
        }
        Block up = this.up();
        while (up instanceof BlockDripleafSmall) {
            this.getLevel().setBlock(up, Block.get(0), true, true);
            this.getLevel().addParticle(new DestroyBlockParticle(up.add(0.5), up));
            up = up.up();
        }
        return super.onBreak(item, player);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() != 351 || item.getDamage() != 15) {
            return false;
        }
        BlockGrowEvent event = new BlockGrowEvent(this, Block.get(578, 0, this));
        this.getLevel().getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        Block down = this.down();
        while (down instanceof BlockDripleafSmall) {
            BlockDripleafBig block = (BlockDripleafBig)Block.get(578);
            block.setDirection(this.getDirection());
            this.getLevel().setBlock(down, block, false, true);
            down = down.down();
        }
        Block up = this;
        while (up instanceof BlockDripleafSmall) {
            BlockDripleafBig block = (BlockDripleafBig)Block.get(578);
            block.setDirection(this.getDirection());
            this.getLevel().setBlock(up, block, false, true);
            up = up.up();
        }
        Block highestPart = this.getLevel().getBlock(up.down());
        if (highestPart instanceof BlockDripleafBig) {
            ((BlockDripleafBig)highestPart).setHasHead(true);
            this.getLevel().setBlock(highestPart, highestPart, false, true);
        }
        this.level.addParticle(new BoneMealParticle(this));
        if (player != null && !player.isCreative()) {
            --item.count;
        }
        return true;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return null;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId()), 0, 1);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public String getName() {
        return "Small Dripleaf";
    }

    @Override
    public int getId() {
        return 591;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.FLOW_INTO_BLOCK;
    }

    public void setHasHead(boolean value) {
        this.setBooleanValue(VanillaProperties.UPPER_BLOCK, value);
    }

    public boolean hasHead() {
        return this.getBooleanValue(VanillaProperties.UPPER_BLOCK);
    }

    public void setDirection(BlockFace blockFace) {
        this.setPropertyValue(VanillaProperties.DIRECTION, blockFace);
    }

    public BlockFace getDirection() {
        return this.getPropertyValue(VanillaProperties.DIRECTION);
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getDirection();
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }
}

