/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallable;
import cn.nukkit.event.block.BlockFromToEvent;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;

public class BlockDragonEgg
extends BlockFallable {
    @Override
    public String getName() {
        return "Dragon Egg";
    }

    @Override
    public int getId() {
        return 122;
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 9.0;
    }

    @Override
    public int getLightLevel() {
        return 1;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.BLACK_BLOCK_COLOR;
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 5) {
            this.teleport();
        }
        return super.onUpdate(type);
    }

    public void teleport() {
        for (int i = 0; i < 1000; ++i) {
            Block to = this.getLevel().getBlock(this.add(Utils.random.nextInt(-16, 16), Utils.random.nextInt(-16, 16), Utils.random.nextInt(-16, 16)));
            if (to.getId() != 0) continue;
            BlockFromToEvent event = new BlockFromToEvent(this, to);
            this.level.getServer().getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            to = event.getTo();
            int diffX = this.getFloorX() - to.getFloorX();
            int diffY = this.getFloorY() - to.getFloorY();
            int diffZ = this.getFloorZ() - to.getFloorZ();
            LevelEventPacket pk = new LevelEventPacket();
            pk.evid = 2010;
            pk.data = Math.abs(diffX) << 16 | Math.abs(diffY) << 8 | Math.abs(diffZ) | (diffX < 0 ? 1 : 0) << 24 | (diffY < 0 ? 1 : 0) << 25 | (diffZ < 0 ? 1 : 0) << 26;
            pk.x = this.getFloorX();
            pk.y = this.getFloorY();
            pk.z = this.getFloorZ();
            this.getLevel().addChunkPacket(this.getChunkX(), this.getChunkZ(), pk);
            this.getLevel().setBlock(this, BlockDragonEgg.get(0), true);
            this.getLevel().setBlock(to, this, true);
            return;
        }
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    @Override
    public boolean alwaysDropsOnExplosion() {
        return true;
    }
}

