/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockDoubleSlabBase;
import cn.nukkit.utils.BlockColor;

public class BlockDoubleSlabStone4
extends BlockDoubleSlabBase {
    private static final String[] NAMES = new String[]{"Mossy Stone Brick", "Smooth Quartz", "Stone", "Cut Sandstone", "Cut Red Sandstone"};
    public static final int MOSSY_STONE_BRICKS = 0;
    public static final int SMOOTH_QUARTZ = 1;
    public static final int STONE = 2;
    public static final int CUT_SANDSTONE = 3;
    public static final int CUT_RED_SANDSTONE = 4;

    public BlockDoubleSlabStone4() {
        this(0);
    }

    public BlockDoubleSlabStone4(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 423;
    }

    @Override
    public int getSingleSlabId() {
        return 421;
    }

    @Override
    public double getResistance() {
        return this.getToolType() > 1 ? 30.0 : 15.0;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getSlabName() {
        int variant = this.getDamage() & 7;
        if (variant >= NAMES.length) {
            return NAMES[0];
        }
        return NAMES[variant];
    }

    @Override
    public int getItemDamage() {
        return this.getDamage() & 7;
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 7) {
            default: {
                return BlockColor.STONE_BLOCK_COLOR;
            }
            case 1: {
                return BlockColor.QUARTZ_BLOCK_COLOR;
            }
            case 3: {
                return BlockColor.SAND_BLOCK_COLOR;
            }
            case 4: 
        }
        return BlockColor.ORANGE_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

