/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockDoubleSlabCopperBase;
import cn.nukkit.block.properties.OxidizationLevel;

public class BlockDoubleSlabCopperCut
extends BlockDoubleSlabCopperBase {
    public BlockDoubleSlabCopperCut() {
        this(0);
    }

    public BlockDoubleSlabCopperCut(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 623;
    }

    @Override
    public String getSlabName() {
        OxidizationLevel oxidizationLevel;
        String name = "";
        if (this.isWaxed()) {
            name = name + "Waxed ";
        }
        if ((oxidizationLevel = this.getOxidizationLevel()) != OxidizationLevel.UNAFFECTED) {
            String oxidationName = oxidizationLevel.name();
            name = name + oxidationName.charAt(0) + oxidationName.substring(1).toLowerCase();
        }
        return name + " Cut Copper";
    }

    @Override
    public int getSingleSlabId() {
        return 616;
    }

    @Override
    public int getItemDamage() {
        return 0;
    }

    @Override
    protected int getCopperId(boolean waxed, OxidizationLevel oxidizationLevel) {
        if (oxidizationLevel == null) {
            return this.getId();
        }
        switch (oxidizationLevel) {
            case UNAFFECTED: {
                return waxed ? 627 : 623;
            }
            case EXPOSED: {
                return waxed ? 628 : 624;
            }
            case WEATHERED: {
                return waxed ? 629 : 625;
            }
            case OXIDIZED: {
                return waxed ? 705 : 626;
            }
        }
        return this.getId();
    }

    @Override
    public OxidizationLevel getOxidizationLevel() {
        return OxidizationLevel.UNAFFECTED;
    }
}

