/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;

public abstract class BlockDoubleSlabBase
extends BlockSolidMeta {
    public BlockDoubleSlabBase() {
        this(0);
    }

    public BlockDoubleSlabBase(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Double " + this.getSlabName() + " Slab";
    }

    public abstract String getSlabName();

    public abstract int getSingleSlabId();

    public abstract int getItemDamage();

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getSingleSlabId(), this.getItemDamage()), this.getItemDamage(), 1);
    }

    protected boolean isCorrectTool(Item item) {
        return this.canHarvestWithHand() || this.canHarvest(item);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (this.isCorrectTool(item)) {
            Item slab = this.toItem();
            slab.setCount(2);
            return new Item[]{slab};
        }
        return new Item[0];
    }
}

