/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;

public class BlockDoublePlant
extends BlockFlowable {
    public static final int SUNFLOWER = 0;
    public static final int LILAC = 1;
    public static final int TALL_GRASS = 2;
    public static final int LARGE_FERN = 3;
    public static final int ROSE_BUSH = 4;
    public static final int PEONY = 5;
    public static final int TOP_HALF_BITMASK = 8;
    private static final String[] NAMES = new String[]{"Sunflower", "Lilac", "Double Tallgrass", "Large Fern", "Rose Bush", "Peony"};

    public BlockDoublePlant() {
        this(0);
    }

    public BlockDoublePlant(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 175;
    }

    @Override
    public boolean canBeReplaced() {
        int damage = this.getDamage() & 7;
        return damage == 2 || damage == 3;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() > 5 ? 0 : this.getDamage()];
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if ((this.getDamage() & 8) == 8) {
                if (this.down().getId() != 175) {
                    this.getLevel().setBlock(this, Block.get(0), false, true);
                    return 1;
                }
            } else {
                Block down = this.down();
                if (down.isTransparent() && down.getId() != 60 || this.up().getId() != 175) {
                    this.getLevel().useBreakOn(this);
                    return 1;
                }
            }
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        Block up = this.up();
        int id = down.getId();
        if (up.getId() == 0 && (id == 2 || id == 3 || id == 243 || id == 60 || id == 110 || id == 575)) {
            this.getLevel().setBlock(up, Block.get(175, this.getDamage() ^ 8), true, false);
            this.getLevel().setBlock(block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        if ((this.getDamage() & 8) == 8) {
            Block down = this.down();
            if (down instanceof BlockDoublePlant) {
                this.getLevel().useBreakOn(down);
            }
        } else {
            this.getLevel().setBlock(this, Block.get(0), true, true);
        }
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        if ((this.getDamage() & 8) != 8) {
            int type = this.getDamage() & 7;
            switch (type) {
                case 2: 
                case 3: {
                    boolean dropSeeds;
                    boolean bl = dropSeeds = Utils.random.nextInt(10) == 0;
                    if (item.isShears()) {
                        if (dropSeeds) {
                            return new Item[]{Item.get(295), Item.get(31, (Integer)(type == 3 ? 2 : 1), 2)};
                        }
                        return new Item[]{Item.get(31, (Integer)(type == 3 ? 2 : 1), 2)};
                    }
                    if (dropSeeds) {
                        return new Item[]{Item.get(295)};
                    }
                    return new Item[0];
                }
            }
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == 15) {
            int type = this.getDamage() & 7;
            if (type == 0 || type == 1 || type == 4 || type == 5) {
                if (player != null && !player.isCreative()) {
                    --item.count;
                }
                this.level.addParticle(new BoneMealParticle(this));
                this.level.dropItem(this, this.toItem());
            }
            return true;
        }
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock((Block)this, this.getDamage() & 7, 1);
    }
}

