/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.utils.Faceable;

public abstract class BlockDoor
extends BlockTransparentMeta
implements Faceable {
    public static final int DOOR_OPEN_BIT = 4;
    public static final int DOOR_TOP_BIT = 8;
    public static final int DOOR_HINGE_BIT = 1;
    public static final int DOOR_POWERED_BIT = 2;
    private static final int[] FACES = new int[]{1, 2, 3, 0};

    protected BlockDoor(int meta) {
        super(meta);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    private int getFullDamage() {
        int up;
        int down;
        if (this.isTop()) {
            down = this.down().getDamage();
            up = this.getDamage();
        } else {
            down = this.getDamage();
            up = this.up().getDamage();
        }
        boolean isRight = (up & 1) > 0;
        return down & 7 | (this.isTop() ? 8 : 0) | (isRight ? 16 : 0);
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        boolean isRight;
        double f = 0.1875;
        int damage = this.getFullDamage();
        SimpleAxisAlignedBB bb = new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 2.0, this.z + 1.0);
        int j = damage & 3;
        boolean isOpen = (damage & 4) > 0;
        boolean bl = isRight = (damage & 0x10) > 0;
        if (j == 0) {
            if (isOpen) {
                if (!isRight) {
                    bb.setBounds(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + f);
                } else {
                    bb.setBounds(this.x, this.y, this.z + 1.0 - f, this.x + 1.0, this.y + 1.0, this.z + 1.0);
                }
            } else {
                bb.setBounds(this.x, this.y, this.z, this.x + f, this.y + 1.0, this.z + 1.0);
            }
        } else if (j == 1) {
            if (isOpen) {
                if (!isRight) {
                    bb.setBounds(this.x + 1.0 - f, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
                } else {
                    bb.setBounds(this.x, this.y, this.z, this.x + f, this.y + 1.0, this.z + 1.0);
                }
            } else {
                bb.setBounds(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + f);
            }
        } else if (j == 2) {
            if (isOpen) {
                if (!isRight) {
                    bb.setBounds(this.x, this.y, this.z + 1.0 - f, this.x + 1.0, this.y + 1.0, this.z + 1.0);
                } else {
                    bb.setBounds(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + f);
                }
            } else {
                bb.setBounds(this.x + 1.0 - f, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
            }
        } else if (j == 3) {
            if (isOpen) {
                if (!isRight) {
                    bb.setBounds(this.x, this.y, this.z, this.x + f, this.y + 1.0, this.z + 1.0);
                } else {
                    bb.setBounds(this.x + 1.0 - f, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
                }
            } else {
                bb.setBounds(this.x, this.y, this.z + 1.0 - f, this.x + 1.0, this.y + 1.0, this.z + 1.0);
            }
        }
        return bb;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().getId() == 0) {
            Block up = this.up();
            if (up instanceof BlockDoor) {
                this.getLevel().setBlock(up, Block.get(0), false);
                this.getLevel().useBreakOn(this, Item.get(270));
            }
            return 1;
        }
        if (type == 6) {
            boolean powered = this.level.isBlockPowered(this);
            if (!this.isOpen() && powered || this.isOpen() && !powered) {
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isOpen() ? 15 : 0, this.isOpen() ? 0 : 15));
                this.toggle(null);
            }
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (this.y > (double)(target.getLevel().getMaxBlockY() - 1)) {
            return false;
        }
        if (face == BlockFace.UP) {
            Block blockUp = this.up();
            if (!blockUp.canBeReplaced() || !BlockDoor.canStayOnFullNonSolid(this.down())) {
                return false;
            }
            int direction = FACES[player != null ? player.getDirection().getHorizontalIndex() : 0];
            Block left = this.getSide(player.getDirection().rotateYCCW());
            Block right = this.getSide(player.getDirection().rotateY());
            int metaUp = 8;
            if (left.getId() == this.getId() || !right.isTransparent() && left.isTransparent()) {
                metaUp |= 1;
            }
            this.setDamage(direction);
            this.getLevel().setBlock(this, this, true, true);
            this.getLevel().setBlock(blockUp, Block.get(this.getId(), metaUp), true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        if (this.isTop(this.getDamage())) {
            Block down = this.down();
            if (down.getId() == this.getId()) {
                this.getLevel().setBlock(down, Block.get(0), true);
            }
        } else {
            Block up = this.up();
            if (up.getId() == this.getId()) {
                this.getLevel().setBlock(up, Block.get(0), true);
            }
        }
        this.getLevel().setBlock(this, Block.get(0), true);
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        return this.toggle(player);
    }

    public boolean toggle(Player player) {
        Block up;
        Block down;
        DoorToggleEvent event = new DoorToggleEvent(this, player);
        this.getLevel().getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        if (this.isTop(this.getDamage())) {
            down = this.down();
            up = this;
        } else {
            down = this;
            up = this.up();
        }
        if (up.getId() != down.getId()) {
            return false;
        }
        int data = down.getDamage() ^ 4;
        this.level.setBlockDataAt(down.getFloorX(), down.getFloorY(), down.getFloorZ(), data);
        if (this.isOpenAfter(data)) {
            this.level.addSound(this, Sound.RANDOM_DOOR_OPEN);
        } else {
            this.level.addSound(this, Sound.RANDOM_DOOR_CLOSE);
        }
        return true;
    }

    private boolean isOpenAfter(int data) {
        if (this.isTop(data)) {
            return (this.down().getDamage() & 4) > 0;
        }
        return (data & 4) > 0;
    }

    public boolean isOpen() {
        if (this.isTop(this.getDamage())) {
            return (this.down().getDamage() & 4) > 0;
        }
        return (this.getDamage() & 4) > 0;
    }

    public boolean isTop() {
        return this.isTop(this.getDamage());
    }

    public boolean isTop(int meta) {
        return (meta & 8) != 0;
    }

    public boolean isRightHinged() {
        if (this.isTop()) {
            return (this.getDamage() & 1) > 0;
        }
        return (this.up().getDamage() & 1) > 0;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

