/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityDispenser;
import cn.nukkit.dispenser.DispenseBehavior;
import cn.nukkit.dispenser.DispenseBehaviorRegister;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.DispenserInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.Utils;
import java.util.Map;

public class BlockDispenser
extends BlockSolidMeta
implements Faceable {
    public BlockDispenser() {
        this(0);
    }

    public BlockDispenser(int meta) {
        super(meta);
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public String getName() {
        return "Dispenser";
    }

    @Override
    public int getId() {
        return 23;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(23));
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityDispenser) {
            return ContainerInventory.calculateRedstone(((BlockEntityDispenser)blockEntity).getInventory());
        }
        return 0;
    }

    public boolean isTriggered() {
        return (this.getDamage() & 8) > 0;
    }

    public void setTriggered(boolean value) {
        int i = 0;
        i |= this.getBlockFace().getIndex();
        if (value) {
            i |= 8;
        }
        this.setDamage(i);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player == null) {
            return false;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (!(blockEntity instanceof BlockEntityDispenser)) {
            return false;
        }
        if (blockEntity.namedTag.contains("Lock") && blockEntity.namedTag.get("Lock") instanceof StringTag && !blockEntity.namedTag.getString("Lock").equals(item.getCustomName())) {
            return true;
        }
        player.addWindow(((BlockEntityDispenser)blockEntity).getInventory());
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (player != null) {
            if (Math.abs(player.x - this.x) < 2.0 && Math.abs(player.z - this.z) < 2.0) {
                double y = player.y + (double)player.getEyeHeight();
                if (y - this.y > 2.0) {
                    this.setDamage(BlockFace.UP.getIndex());
                } else if (this.y - y > 0.0) {
                    this.setDamage(BlockFace.DOWN.getIndex());
                } else {
                    this.setDamage(player.getHorizontalFacing().getOpposite().getIndex());
                }
            } else {
                this.setDamage(player.getHorizontalFacing().getOpposite().getIndex());
            }
        }
        this.getLevel().setBlock(block, this, true);
        BlockEntity.createBlockEntity("Dispenser", this.getChunk(), BlockEntity.getDefaultCompound(this, "Dispenser"), new Object[0]);
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 3) {
            this.setTriggered(false);
            this.level.setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, false, false);
            this.dispense();
            return type;
        }
        if (type == 6) {
            if (!this.isTriggered() && (this.level.isBlockPowered(this) || this.level.isBlockPowered(this.getSideVec(BlockFace.UP)))) {
                this.setTriggered(true);
                this.level.setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, false, false);
                this.level.scheduleUpdate(this, this, 4);
            }
            return type;
        }
        return 0;
    }

    public void dispense() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (!(blockEntity instanceof BlockEntityDispenser)) {
            return;
        }
        this.level.addLevelSoundEvent(this, 363);
        int r = 1;
        int slot = -1;
        Item target = null;
        DispenserInventory inv = ((BlockEntityDispenser)blockEntity).getInventory();
        for (Map.Entry<Integer, Item> entry : inv.getContents().entrySet()) {
            Item item = entry.getValue();
            if (item.isNull() || Utils.random.nextInt(r++) != 0) continue;
            target = item;
            slot = entry.getKey();
        }
        if (target == null) {
            return;
        }
        DispenseBehavior behavior = DispenseBehaviorRegister.getBehavior((target = target.clone()).getId());
        Item result = behavior.dispense(this, this.getBlockFace(), target);
        if (result == null) {
            --target.count;
            inv.setItem(slot, target);
        } else if (!result.equals(target)) {
            inv.setItem(slot, result);
        }
    }

    public Vector3 getDispensePosition() {
        BlockFace facing = this.getBlockFace();
        return this.add(0.5 + 0.7 * (double)facing.getXOffset(), 0.5 + 0.7 * (double)facing.getYOffset(), 0.5 + 0.7 * (double)facing.getZOffset());
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage() & 7);
    }

    @Override
    public double getHardness() {
        return 3.5;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

