/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockDirt;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.BoneMealParticle;

public class BlockDirtRooted
extends BlockDirt {
    public BlockDirtRooted() {
        this(0);
    }

    public BlockDirtRooted(int meta) {
        super(0);
    }

    @Override
    public int getId() {
        return 573;
    }

    @Override
    public String getName() {
        return "Rooted Dirt";
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        Block up = this.up();
        if (item.isShovel() && (up instanceof BlockAir || up instanceof BlockFlowable)) {
            item.useOn(this);
            this.getLevel().setBlock(this, Block.get(198));
            if (player != null) {
                player.getLevel().addSound(player, Sound.STEP_GRASS);
            }
            return true;
        }
        if (item.isHoe() && (up instanceof BlockAir || up instanceof BlockFlowable)) {
            item.useOn(this);
            this.getLevel().setBlock(this, Block.get(3));
            if (player != null) {
                player.getLevel().addSound(player, Sound.STEP_GRASS);
            }
            this.getLevel().dropItem(this.add(0.5, 0.8, 0.5), new ItemBlock(Block.get(574), 0));
            return true;
        }
        if (item.getId() != 351 || item.getDamage() != 15) {
            return false;
        }
        Block down = this.down();
        BlockGrowEvent event = new BlockGrowEvent(down, Block.get(574, 0, down));
        this.getLevel().getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        if (down.getId() == 0 || down.canBeReplaced()) {
            this.getLevel().setBlock(down, Block.get(574));
            this.level.addParticle(new BoneMealParticle(down));
            return true;
        }
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId()), 0, 1);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{this.toItem()};
    }
}

