/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.level.generator.object.ObjectTallGrass;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.utils.BlockColor;

public class BlockDirt
extends BlockSolidMeta {
    public BlockDirt() {
        this(0);
    }

    public BlockDirt(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public String getName() {
        return this.getDamage() == 0 ? "Dirt" : "Coarse Dirt";
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.isHoe()) {
            Block up = this.up();
            if (up instanceof BlockAir || up instanceof BlockFlowable) {
                item.useOn(this);
                this.getLevel().setBlock(this, this.getDamage() == 0 ? BlockDirt.get(60) : BlockDirt.get(3), true);
                if (player != null) {
                    player.getLevel().addSound(player, Sound.STEP_GRASS);
                }
                return true;
            }
        } else if (item.isShovel()) {
            Block up = this.up();
            if (up instanceof BlockAir || up instanceof BlockFlowable) {
                item.useOn(this);
                this.getLevel().setBlock(this, Block.get(198));
                if (player != null) {
                    player.getLevel().addSound(player, Sound.STEP_GRASS);
                }
                return true;
            }
        } else if (player != null && item.getId() == 351 && item.getDamage() == 15) {
            Block up = this.up();
            if (up instanceof BlockWater) {
                if (!player.isCreative()) {
                    --item.count;
                }
                this.level.addParticle(new BoneMealParticle(this));
                if (up.up() instanceof BlockWater) {
                    ObjectTallGrass.growSeagrass(this.getLevel(), this);
                }
                return true;
            }
        } else if (player != null && item.getId() == 373 && item.getDamage() == 0) {
            --item.count;
            Item emptyBottle = Item.get(374);
            if (player.getInventory().canAddItem(emptyBottle)) {
                player.getInventory().addItem(emptyBottle);
            } else {
                player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), emptyBottle, player.getDirectionVector().multiply(0.4));
            }
            this.getLevel().setBlock(this, BlockDirt.get(728), true);
            return true;
        }
        return false;
    }

    @Override
    public Item[] getDrops(Item item) {
        int damage = this.getDamage() & 1;
        return new Item[]{new ItemBlock(Block.get(3, damage), damage)};
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.DIRT_BLOCK_COLOR;
    }
}

