/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;

public class BlockDeepslate
extends BlockSolidMeta {
    public BlockDeepslate() {
        this(0);
    }

    public BlockDeepslate(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Deepslate";
    }

    @Override
    public int getId() {
        return 633;
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setPillarAxis(face.getAxis());
        this.getLevel().setBlock(block, this, true, true);
        return true;
    }

    public void setPillarAxis(BlockFace.Axis axis) {
        switch (axis) {
            case Y: {
                this.setDamage(0);
                break;
            }
            case X: {
                this.setDamage(1);
                break;
            }
            case Z: {
                this.setDamage(2);
            }
        }
    }

    public BlockFace.Axis getPillarAxis() {
        switch (this.getDamage() % 3) {
            case 2: {
                return BlockFace.Axis.Z;
            }
            case 1: {
                return BlockFace.Axis.X;
            }
        }
        return BlockFace.Axis.Y;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(633), 0);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (!this.canHarvest(item)) {
            return new Item[0];
        }
        return new Item[]{new ItemBlock(Block.get(634), 0)};
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.DEEPSLATE_GRAY;
    }
}

