/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFungus;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.level.generator.object.tree.ObjectCrimsonTree;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockCrimsonFungus
extends BlockFungus {
    @Override
    public int getId() {
        return 483;
    }

    @Override
    public String getName() {
        return "Crimson Fungus";
    }

    @Override
    protected boolean canGrowOn(Block support) {
        return support.getId() == 487;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().isTransparent()) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public boolean grow(Player cause) {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.NETHERRACK_BLOCK_COLOR;
    }

    @Override
    public boolean canPlaceOn(Block floor, Position pos) {
        switch (floor.getId()) {
            case 2: 
            case 3: 
            case 60: 
            case 110: 
            case 243: 
            case 487: 
            case 488: 
            case 491: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == DyeColor.WHITE.getDyeData()) {
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            if ((double)ThreadLocalRandom.current().nextFloat() < 0.4 && this.level.getBlockIdAt((int)this.x, (int)this.y - 1, (int)this.z) == 487) {
                new ObjectCrimsonTree().placeObject(this.level, (int)this.x, (int)this.y, (int)this.z, new NukkitRandom());
                this.level.setBlock(new Vector3((int)this.x, (int)this.y - 1, (int)this.z), Block.get(87), false, true);
            }
            this.level.addParticle(new BoneMealParticle(this));
            return true;
        }
        return false;
    }
}

