/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.event.player.CraftingTableOpenEvent;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.ContainerOpenPacket;
import cn.nukkit.utils.BlockColor;

public class BlockCraftingTable
extends BlockSolid {
    @Override
    public String getName() {
        return "Crafting Table";
    }

    @Override
    public int getId() {
        return 58;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 2.5;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            CraftingTableOpenEvent ev = new CraftingTableOpenEvent(player, this);
            player.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                if (player.craftingType == 1) {
                    player.getServer().getLogger().debug(player.getName() + " tried to activate crafting table but craftingType is already CRAFTING_BIG");
                    return true;
                }
                player.craftingType = 1;
                player.setCraftingGrid(player.getUIInventory().getBigCraftingGrid());
                ContainerOpenPacket pk = new ContainerOpenPacket();
                pk.windowId = -1;
                pk.type = 1;
                pk.x = (int)this.x;
                pk.y = (int)this.y;
                pk.z = (int)this.z;
                pk.entityId = player.getId();
                player.dataPacket(pk);
            }
        }
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }
}

