/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCoralFan;
import cn.nukkit.block.BlockCoralFanDead;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;

public class BlockCoralFanHang
extends BlockCoralFan {
    public BlockCoralFanHang() {
        this(0);
    }

    public BlockCoralFanHang(int meta) {
        super(meta);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            return type;
        }
        return super.onUpdate(type);
    }

    @Override
    public int getType() {
        if ((this.getDamage() & 1) == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public BlockFace getBlockFace() {
        int face = this.getDamage() >> 2 & 3;
        switch (face) {
            case 0: {
                return BlockFace.WEST;
            }
            case 1: {
                return BlockFace.EAST;
            }
            case 2: {
                return BlockFace.NORTH;
            }
        }
        return BlockFace.SOUTH;
    }

    @Override
    public String getName() {
        String name = super.getName();
        name = name.substring(0, name.length() - 4);
        if (this.isDead()) {
            return "Dead " + name + " Wall Fan";
        }
        return name + " Wall Fan";
    }

    @Override
    public boolean isDead() {
        return (this.getDamage() & 2) == 2;
    }

    @Override
    public BlockFace getRootsFace() {
        return this.getBlockFace().getOpposite();
    }

    @Override
    public int getId() {
        return 390;
    }

    @Override
    public Item toItem() {
        return new ItemBlock((Block)(this.isDead() ? new BlockCoralFanDead() : new BlockCoralFan()), this.getType());
    }
}

