/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCoral;
import cn.nukkit.block.BlockCoralFanDead;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.Faceable;
import java.util.concurrent.ThreadLocalRandom;

public class BlockCoralFan
extends BlockCoral
implements Faceable {
    private static final String[] NAMES = new String[]{"Tube Coral Fan", "Brain Coral Fan", "Bubble Coral Fan", "Fire Coral Fan", "Horn Coral Fan"};

    public BlockCoralFan() {
        this(0);
    }

    public BlockCoralFan(int meta) {
        super(meta);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block side = this.getSide(this.getRootsFace());
            if (!side.isSolid() || side.getId() == 213 || side.getId() == 88) {
                this.getLevel().useBreakOn(this);
            } else {
                this.getLevel().scheduleUpdate(this, 60 + ThreadLocalRandom.current().nextInt(40));
            }
            return type;
        }
        if (type == 3) {
            Block side = this.getSide(this.getRootsFace());
            if (side.getId() == 79) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            if (!(this.isDead() || this.getLevelBlock(BlockLayer.WATERLOGGED) instanceof BlockWater || this.getLevelBlock(BlockLayer.WATERLOGGED) instanceof BlockIceFrosted)) {
                BlockFadeEvent event = new BlockFadeEvent(this, Block.get(389, this.getDamage()));
                this.level.getServer().getPluginManager().callEvent(event);
                if (!event.isCancelled()) {
                    this.getLevel().setBlock(this, event.getNewState(), true, true);
                }
            }
            return type;
        }
        if (type == 2) {
            if ((this.getDamage() & 8) == 0) {
                this.setDamage(this.getDamage() | 8);
            } else {
                this.setDamage(this.getDamage() ^ 8);
            }
            this.getLevel().setBlock(this, this, true, true);
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (face == BlockFace.DOWN) {
            return false;
        }
        Block layer1 = block.getLevelBlock(BlockLayer.WATERLOGGED);
        boolean hasWater = layer1 instanceof BlockWater;
        if (layer1.getId() != 0 && (!hasWater || layer1.getDamage() != 0 && layer1.getDamage() != 8)) {
            return false;
        }
        if (hasWater && layer1.getDamage() == 8) {
            this.getLevel().setBlock(this, BlockLayer.WATERLOGGED, Block.get(8), true, false);
        }
        if (!target.isSolid() || target.getId() == 213 || target.getId() == 88) {
            return false;
        }
        if (face == BlockFace.UP) {
            double rotation = player.yaw % 360.0;
            if (rotation < 0.0) {
                rotation += 360.0;
            }
            int axisBit = rotation >= 0.0 && rotation < 12.0 || 342.0 <= rotation && rotation < 360.0 ? 0 : 8;
            this.setDamage(this.getDamage() & 7 | axisBit);
            this.getLevel().setBlock(this, BlockLayer.NORMAL, hasWater ? new BlockCoralFan(this.getDamage()) : new BlockCoralFanDead(this.getDamage()), true, true);
        } else {
            int deadBlockId;
            int faceBit;
            int type = this.getType();
            int typeBit = type % 2;
            int deadBit = this.isDead() ? 1 : 0;
            switch (face) {
                case WEST: {
                    faceBit = 0;
                    break;
                }
                case EAST: {
                    faceBit = 1;
                    break;
                }
                case NORTH: {
                    faceBit = 2;
                    break;
                }
                default: {
                    faceBit = 3;
                }
            }
            int deadData = faceBit << 2 | deadBit << 1 | typeBit;
            switch (type) {
                default: {
                    deadBlockId = 390;
                    break;
                }
                case 2: 
                case 3: {
                    deadBlockId = 391;
                    break;
                }
                case 4: {
                    deadBlockId = 392;
                }
            }
            this.getLevel().setBlock(this, BlockLayer.NORMAL, Block.get(deadBlockId, deadData), true, true);
        }
        return true;
    }

    @Override
    public String getName() {
        int variant = this.getType();
        String name = variant >= NAMES.length ? NAMES[0] : NAMES[variant];
        return name;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.FLOW_INTO_BLOCK;
    }

    @Override
    public int getId() {
        return 388;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public Item toItem() {
        return Item.get(this.getItemId(), (Integer)(this.getDamage() ^ 8));
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.getEnchantment(16) != null) {
            return super.getDrops(item);
        }
        return new Item[0];
    }

    public boolean isDead() {
        return false;
    }

    public int getType() {
        return this.getDamage() & 7;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    public BlockFace getRootsFace() {
        return BlockFace.DOWN;
    }
}

