/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import java.util.concurrent.ThreadLocalRandom;

public class BlockCoralBlock
extends BlockSolidMeta {
    private static final String[] NAMES = new String[]{"Tube Coral Block", "Brain Coral Block", "Bubble Coral Block", "Fire Coral Block", "Horn Coral Block"};

    public BlockCoralBlock() {
        this(0);
    }

    public BlockCoralBlock(int meta) {
        super(meta);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.isDead()) {
                this.getLevel().scheduleUpdate(this, 60 + ThreadLocalRandom.current().nextInt(40));
            }
            return type;
        }
        if (type != 3) {
            return 0;
        }
        if (this.isDead()) {
            return type;
        }
        for (BlockFace face : BlockFace.values()) {
            if (!(this.getSide(BlockLayer.NORMAL, face) instanceof BlockWater) && !(this.getSide(BlockLayer.WATERLOGGED, face) instanceof BlockWater) && !(this.getSide(BlockLayer.NORMAL, face) instanceof BlockIceFrosted) && !(this.getSide(BlockLayer.WATERLOGGED, face) instanceof BlockIceFrosted)) continue;
            return type;
        }
        BlockFadeEvent event = new BlockFadeEvent(this, Block.get(387, this.getDamage() | 8));
        this.level.getServer().getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.setDead(true);
            this.getLevel().setBlock(this, event.getNewState(), true, true);
        }
        return type;
    }

    @Override
    public double getHardness() {
        return 1.5;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public String getName() {
        int variant = this.getDamage() & 7;
        String name = variant >= NAMES.length ? NAMES[0] : NAMES[variant];
        return this.isDead() ? "Dead " + name : name;
    }

    @Override
    public int getId() {
        return 387;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            if (item.getEnchantment(16) != null) {
                return new Item[]{this.toItem()};
            }
            return new Item[]{new ItemBlock(this.clone(), this.getDamage() | 8)};
        }
        return new Item[0];
    }

    public boolean isDead() {
        return (this.getDamage() & 8) == 8;
    }

    public void setDead(boolean dead) {
        if (dead) {
            this.setDamage(this.getDamage() | 8);
        } else {
            this.setDamage(this.getDamage() ^ 8);
        }
    }
}

