/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockCopperBase;
import cn.nukkit.block.properties.OxidizationLevel;
import cn.nukkit.utils.BlockColor;

public class BlockCopperCut
extends BlockCopperBase {
    @Override
    public String getName() {
        return "Cut Copper";
    }

    @Override
    public int getId() {
        return 602;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.ORANGE_BLOCK_COLOR;
    }

    @Override
    public OxidizationLevel getOxidizationLevel() {
        return OxidizationLevel.UNAFFECTED;
    }

    @Override
    protected int getCopperId(boolean waxed, OxidizationLevel oxidizationLevel) {
        if (oxidizationLevel == null) {
            return this.getId();
        }
        switch (oxidizationLevel) {
            case UNAFFECTED: {
                return waxed ? 606 : 602;
            }
            case EXPOSED: {
                return waxed ? 607 : 603;
            }
            case WEATHERED: {
                return waxed ? 608 : 604;
            }
            case OXIDIZED: {
                return waxed ? 702 : 605;
            }
        }
        return this.getId();
    }
}

