/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallableMeta;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;

public class BlockConcretePowder
extends BlockFallableMeta {
    public BlockConcretePowder() {
        super(0);
    }

    public BlockConcretePowder(int meta) {
        super(meta);
    }

    @Override
    public int getFullId() {
        return 15168 + this.getDamage();
    }

    @Override
    public int getId() {
        return 237;
    }

    @Override
    public String getName() {
        return this.getDyeColor().getName() + " Concrete Powder";
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            super.onUpdate(1);
            for (int side = 1; side <= 5; ++side) {
                Block block = this.getSide(BlockFace.fromIndex(side));
                if (block.getId() != 8 && block.getId() != 9) continue;
                this.level.setBlock(this, Block.get(236, this.getDamage()), true, true);
            }
            return 1;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block b, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean concrete = false;
        for (int side = 1; side <= 5; ++side) {
            Block block = this.getSide(BlockFace.fromIndex(side));
            if (block.getId() != 8 && block.getId() != 9) continue;
            concrete = true;
            break;
        }
        if (concrete) {
            this.level.setBlock(this, Block.get(236, this.getDamage()), true, true);
        } else {
            this.level.setBlock(this, this, true, true);
        }
        return true;
    }

    @Override
    public BlockColor getColor() {
        return DyeColor.getByWoolData(this.getDamage()).getColor();
    }

    public DyeColor getDyeColor() {
        return DyeColor.getByWoolData(this.getDamage());
    }
}

