/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.ComposterEmptyEvent;
import cn.nukkit.event.block.ComposterFillEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemDye;
import cn.nukkit.item.ItemID;
import cn.nukkit.level.Sound;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

public class BlockComposter
extends BlockTransparentMeta
implements ItemID {
    private static final Int2IntOpenHashMap ITEMS = new Int2IntOpenHashMap();

    public BlockComposter() {
        this(0);
    }

    public BlockComposter(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 468;
    }

    @Override
    public String getName() {
        return "Composter";
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 0.6;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.getDamage();
    }

    public boolean incrementLevel() {
        int fillLevel = this.getDamage() + 1;
        this.setDamage(fillLevel);
        this.level.setBlock(this, this, true, true);
        return fillLevel == 8;
    }

    public boolean isFull() {
        return this.getDamage() == 8;
    }

    public boolean isEmpty() {
        return this.getDamage() == 0;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getCount() <= 0 || item.getId() == 0) {
            return false;
        }
        if (this.isFull()) {
            this.empty(item, player);
            return true;
        }
        int chance = BlockComposter.getChance(item);
        if (chance <= 0) {
            return false;
        }
        boolean success = Utils.random.nextInt(100) < chance;
        ComposterFillEvent event = new ComposterFillEvent(this, player, item, chance, success);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return true;
        }
        if (player != null && !player.isCreative()) {
            item.setCount(item.getCount() - 1);
        }
        if (event.isSuccess()) {
            if (this.incrementLevel()) {
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_COMPOSTER_READY);
            } else {
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_COMPOSTER_FILL_SUCCESS);
            }
        } else {
            this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_COMPOSTER_FILL);
        }
        return true;
    }

    public Item empty() {
        return this.empty(null, null);
    }

    public Item empty(Player player) {
        return this.empty(null, player);
    }

    public Item empty(Item item, Player player) {
        if (this.isEmpty()) {
            return null;
        }
        ComposterEmptyEvent event = new ComposterEmptyEvent(this, player, item, new ItemDye(DyeColor.WHITE), 0);
        this.level.getServer().getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.setDamage(event.getNewLevel());
            this.level.setBlock(this, this, true, true);
            if (item != null) {
                this.level.dropItem(this.add(0.5, 0.85, 0.5), event.getDrop());
            }
            this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_COMPOSTER_EMPTY);
            return event.getDrop();
        }
        return null;
    }

    public static void registerItem(int chance, int itemId) {
        BlockComposter.registerItem(chance, itemId, 0);
    }

    public static void registerItem(int chance, int itemId, int meta) {
        ITEMS.put(itemId << 6 | meta & 0x3F, chance);
    }

    public static void registerItems(int chance, int ... itemIds) {
        for (int itemId : itemIds) {
            BlockComposter.registerItem(chance, itemId, 0);
        }
    }

    public static void registerBlocks(int chance, int ... blockIds) {
        for (int blockId : blockIds) {
            BlockComposter.registerBlock(chance, blockId, 0);
        }
    }

    public static void registerBlock(int chance, int blockId) {
        BlockComposter.registerBlock(chance, blockId, 0);
    }

    public static void registerBlock(int chance, int blockId, int meta) {
        if (blockId > 255) {
            blockId = 255 - blockId;
        }
        BlockComposter.registerItem(chance, blockId, meta);
    }

    public static void register(int chance, Item item) {
        BlockComposter.registerItem(chance, item.getId(), item.getDamage());
    }

    public static int getChance(Item item) {
        int chance = ITEMS.get(item.getId() << 6 | item.getDamage());
        if (chance == 0) {
            chance = ITEMS.get(item.getId() << 6);
        }
        return chance;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    static {
        BlockComposter.registerItems(30, 335, 458, 464, 362, 361, 477, 295);
        BlockComposter.registerItems(50, 360, 338);
        BlockComposter.registerItems(65, 260, 457, 391, 127, 392, 296);
        BlockComposter.registerItems(85, 393, 297, 357);
        BlockComposter.registerItems(100, 354, 400);
        BlockComposter.registerBlocks(30, 393, 18, 161, 6, 385, 462);
        BlockComposter.registerBlocks(50, 2, 81, 394, 106, 493);
        BlockComposter.registerBlocks(65, 37, 38, 175, 471, 111, 103, 86, 410, 411, 39, 40, 485, 483, 484, 282);
        BlockComposter.registerBlocks(85, 170, 99, 100, 214, 482);
        BlockComposter.registerBlocks(100, 92);
        BlockComposter.registerBlock(50, 31, 0);
        BlockComposter.registerBlock(50, 31, 1);
        BlockComposter.registerBlock(65, 31, 2);
        BlockComposter.registerBlock(65, 31, 3);
    }
}

