/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Utils;

public class BlockChorusPlant
extends BlockTransparent {
    @Override
    public int getId() {
        return 240;
    }

    @Override
    public String getName() {
        return "Chorus Plant";
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public double getResistance() {
        return 0.4;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!this.isSupportValid()) {
            return false;
        }
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @Override
    public int getToolType() {
        return 4;
    }

    private boolean isSupportValid() {
        int down = this.down().getId();
        if (down == 240 || down == 121) {
            return true;
        }
        if (down != 0) {
            return false;
        }
        boolean plantFound = false;
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            if (this.getSide(face).getId() != 240) continue;
            if (plantFound) {
                return false;
            }
            plantFound = true;
        }
        return plantFound;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.isSupportValid()) {
                this.getLevel().scheduleUpdate(this, 1);
                return type;
            }
        } else if (type == 3) {
            this.getLevel().useBreakOn(this, null, null, true);
            return type;
        }
        return 0;
    }

    @Override
    public Item[] getDrops(Item item) {
        Item[] itemArray;
        if (item.hasEnchantment(16)) {
            return new Item[]{this.toItem()};
        }
        if (Utils.rand()) {
            Item[] itemArray2 = new Item[1];
            itemArray = itemArray2;
            itemArray2[0] = Item.get(432, (Integer)0, 1);
        } else {
            itemArray = new Item[]{};
        }
        return itemArray;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.PURPLE_BLOCK_COLOR;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

