/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.projectile.EntitySnowball;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockChorusFlower
extends BlockTransparentMeta {
    public BlockChorusFlower() {
        super(0);
    }

    public BlockChorusFlower(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 200;
    }

    @Override
    public String getName() {
        return "Chorus Flower";
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public double getResistance() {
        return 0.4;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    private boolean isPositionValid() {
        Block down = this.down();
        if (down.getId() == 240 || down.getId() == 121) {
            return true;
        }
        if (down.getId() != 0) {
            return false;
        }
        boolean foundPlant = false;
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            Block side = this.getSide(face);
            if (side.getId() != 240) continue;
            if (foundPlant) {
                return false;
            }
            foundPlant = true;
        }
        return foundPlant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int onUpdate(int type) {
        Block up;
        if (type == 1) {
            if (this.isPositionValid()) return 0;
            this.getLevel().scheduleUpdate(this, 1);
            return type;
        }
        if (type == 3) {
            this.getLevel().useBreakOn(this, null, null, true);
            return type;
        }
        if (type != 2) return 0;
        if (!(this.y < (double)this.level.getMaxBlockY()) || (up = this.up()).getId() != 0) return 2;
        if (this.isFullyAged()) return 0;
        boolean growUp = false;
        boolean ground = false;
        Block down = this.down();
        if (down.getId() == 0 || down.getId() == 121) {
            growUp = true;
        } else if (down.getId() == 240) {
            int height = 1;
            for (int y = 2; y < 6; ++y) {
                Block downY = this.down(y);
                if (downY.getId() == 240) {
                    ++height;
                    continue;
                }
                if (downY.getId() != 121) break;
                ground = true;
                break;
            }
            if (height < 2 || height <= ThreadLocalRandom.current().nextInt(ground ? 5 : 4)) {
                growUp = true;
            }
        }
        if (growUp && up.up().getId() == 0 && this.isHorizontalAir(up)) {
            BlockChorusFlower block = (BlockChorusFlower)this.clone();
            block.y = this.y + 1.0;
            BlockGrowEvent ev = new BlockGrowEvent(this, block);
            Server.getInstance().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) return 2;
            this.getLevel().setBlock(this, Block.get(240));
            this.getLevel().setBlock(block, ev.getNewState());
            this.level.addLevelSoundEvent(this, 125);
            return 0;
        } else if (!this.isFullyAged()) {
            for (int i = 0; i < ThreadLocalRandom.current().nextInt(ground ? 5 : 4); ++i) {
                BlockFace face = BlockFace.Plane.HORIZONTAL.random();
                Block check = this.getSide(face);
                if (check.getId() != 0 || check.down().getId() != 0 || !this.isHorizontalAirExcept(check, face.getOpposite())) continue;
                BlockChorusFlower block = (BlockChorusFlower)this.clone();
                block.x = check.x;
                block.y = check.y;
                block.z = check.z;
                block.setAge(this.getAge() + 1);
                BlockGrowEvent ev = new BlockGrowEvent(this, block);
                Server.getInstance().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) return 2;
                this.getLevel().setBlock(this, Block.get(240));
                this.getLevel().setBlock(block, ev.getNewState());
                this.level.addLevelSoundEvent(this, 125);
            }
            return 0;
        } else {
            BlockChorusFlower block = (BlockChorusFlower)this.clone();
            block.setAge(this.getMaxAge());
            BlockGrowEvent ev = new BlockGrowEvent(this, block);
            Server.getInstance().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) return 2;
            this.getLevel().setBlock(block, ev.getNewState());
            this.level.addLevelSoundEvent(this, 126);
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!this.isPositionValid()) {
            return false;
        }
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{this.toItem()};
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (entity instanceof EntityArrow || entity instanceof EntitySnowball) {
            entity.close();
            this.getLevel().useBreakOn(this);
        }
    }

    public int getMaxAge() {
        return 5;
    }

    public int getAge() {
        return this.getDamage();
    }

    public void setAge(int age) {
        this.setDamage(age);
    }

    public boolean isFullyAged() {
        return this.getAge() >= this.getMaxAge();
    }

    private boolean isHorizontalAir(Block block) {
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            if (block.getSide(face).getId() == 0) continue;
            return false;
        }
        return true;
    }

    private boolean isHorizontalAirExcept(Block block, BlockFace except) {
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            if (face == except || block.getSide(face).getId() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.PURPLE_BLOCK_COLOR;
    }
}

