/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityChest;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.util.Map;

public class BlockChest
extends BlockTransparentMeta
implements Faceable {
    public BlockChest() {
        this(0);
    }

    public BlockChest(int meta) {
        super(meta);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getId() {
        return 54;
    }

    @Override
    public String getName() {
        return "Chest";
    }

    @Override
    public double getHardness() {
        return 2.5;
    }

    @Override
    public double getResistance() {
        return 12.5;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        BlockEntityChest chest = null;
        this.setDamage(Block.FACES2534[player != null ? player.getDirection().getHorizontalIndex() : 0]);
        for (BlockFace side : BlockFace.Plane.HORIZONTAL) {
            BlockEntity blockEntity;
            Block c;
            if ((this.getDamage() == 4 || this.getDamage() == 5) && (side == BlockFace.WEST || side == BlockFace.EAST) || (this.getDamage() == 3 || this.getDamage() == 2) && (side == BlockFace.NORTH || side == BlockFace.SOUTH) || !((c = this.getSide(side)) instanceof BlockChest) || c.getDamage() != this.getDamage() && (c.getDamage() != 0 || this.getDamage() != 2) || !((blockEntity = this.getLevel().getBlockEntity(c)) instanceof BlockEntityChest) || ((BlockEntityChest)blockEntity).isPaired()) continue;
            chest = (BlockEntityChest)blockEntity;
            break;
        }
        this.getLevel().setBlock(this, this, true, true);
        CompoundTag nbt = new CompoundTag("").putList(new ListTag("Items")).putString("id", "Chest").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        BlockEntityChest blockEntity = (BlockEntityChest)BlockEntity.createBlockEntity("Chest", this.getChunk(), nbt, new Object[0]);
        if (chest != null) {
            chest.pairWith(blockEntity);
            blockEntity.pairWith(chest);
        }
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        BlockEntity t2 = this.getLevel().getBlockEntity(this);
        if (t2 instanceof BlockEntityChest) {
            ((BlockEntityChest)t2).unpair();
        }
        this.getLevel().setBlock(this, Block.get(0), true, true);
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            Block top = this.up();
            if (!(top instanceof BlockStairs) && !top.isTransparent()) {
                return true;
            }
            BlockEntity t2 = this.getLevel().getBlockEntity(this);
            if (!(t2 instanceof BlockEntityChest)) {
                return false;
            }
            BlockEntityChest chest = (BlockEntityChest)t2;
            if (chest.namedTag.contains("Lock") && chest.namedTag.get("Lock") instanceof StringTag && !chest.namedTag.getString("Lock").equals(item.getCustomName())) {
                return true;
            }
            player.addWindow(chest.getInventory());
        }
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityChest) {
            return ContainerInventory.calculateRedstone(((BlockEntityChest)blockEntity).getInventory());
        }
        return super.getComparatorInputOverride();
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }
}

