/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;

public class BlockChain
extends BlockTransparentMeta {
    public BlockChain() {
        this(0);
    }

    public BlockChain(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Chain";
    }

    @Override
    public int getId() {
        return 541;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setPillarAxis(face.getAxis());
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    public void setPillarAxis(BlockFace.Axis axis) {
        switch (axis) {
            case Y: {
                this.setDamage(0);
                break;
            }
            case X: {
                this.setDamage(1);
                break;
            }
            case Z: {
                this.setDamage(2);
            }
        }
    }

    public BlockFace.Axis getPillarAxis() {
        switch (this.getDamage() % 3) {
            case 2: {
                return BlockFace.Axis.Z;
            }
            case 1: {
                return BlockFace.Axis.X;
            }
        }
        return BlockFace.Axis.Y;
    }

    @Override
    public double getHardness() {
        return 5.0;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getMinX() {
        return this.x + 0.4375;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.5625;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.4375;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.5625;
    }

    @Override
    public Item toItem() {
        return Item.get(758);
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

