/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import java.util.concurrent.ThreadLocalRandom;

public class BlockCaveVines
extends BlockTransparentMeta {
    private static final float CHANCE_OF_BERRIES_ON_GROWTH = 0.132f;

    public BlockCaveVines() {
        this(0);
    }

    public BlockCaveVines(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Cave Vines";
    }

    @Override
    public int getId() {
        return 577;
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean canPlaceOn(Block floor, Position pos) {
        Block up = floor.up(2);
        return (up.isSolid() || up instanceof BlockCaveVines) && super.canPlaceOn(floor, pos);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!this.canPlaceOn(block.down(), target)) {
            return false;
        }
        Block support = block.up();
        if (BlockCaveVines.isCaveVine(support)) {
            this.setVineAge(Math.min(this.getMaxAge(), ((BlockCaveVines)support).getVineAge() + 1));
        } else {
            this.setVineAge(0);
        }
        return this.getLevel().setBlock(this, this, true, true);
    }

    @Override
    public int onUpdate(int type) {
        switch (type) {
            case 1: {
                Block up = this.up();
                if (BlockCaveVines.isCaveVine(up) || up.isSolid()) break;
                this.getLevel().scheduleUpdate(this, 1);
                break;
            }
            case 3: {
                this.getLevel().useBreakOn(this, null, null, true);
                break;
            }
            case 2: {
                if (this.tryGrowItself()) break;
                this.tryGrow();
            }
        }
        return type;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (this.tryPickupBerries()) {
            return true;
        }
        if (item.getId() != 351 || item.getDamage() != 15) {
            return false;
        }
        Block bottom = this;
        BlockCaveVines plantHead = null;
        while (bottom instanceof BlockCaveVines) {
            plantHead = bottom;
            bottom = bottom.down();
        }
        if (!super.tryGrow()) {
            return false;
        }
        this.level.addParticle(new BoneMealParticle(plantHead));
        if (player != null && !player.isCreative()) {
            --item.count;
        }
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    private boolean tryPickupBerries() {
        if (!this.hasBerries()) {
            return false;
        }
        BlockCaveVines blockCaveVines = this.getStateWithoutBerries(this);
        this.getLevel().setBlock(this, blockCaveVines, false, true);
        Item item = Item.get(654, (Integer)0, 1);
        this.getLevel().dropItem(this.add(0.5, 0.5, 0.5), item);
        return true;
    }

    private boolean tryGrow() {
        if (this.getVineAge() >= this.getMaxAge()) {
            return false;
        }
        Block down = this.down();
        if (down.getY() <= (double)this.getLevel().getMinBlockY() || down.getId() != 0) {
            return false;
        }
        Block topBlock = this;
        while (topBlock instanceof BlockCaveVines && ((Block)topBlock).getDamage() >= this.getVineAge()) {
            topBlock = topBlock.up();
        }
        if (((Block)topBlock).getDamage() >= this.getMaxAge()) {
            return false;
        }
        boolean withBerries = ThreadLocalRandom.current().nextFloat() < 0.132f;
        BlockCaveVines head = withBerries ? this.getStateWithBerries(down) : this.getStateWithoutBerries(down);
        BlockGrowEvent event = new BlockGrowEvent(this, head);
        this.getLevel().getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        this.getLevel().setBlock(down, event.getNewState(), true, true);
        BlockCaveVines support = (BlockCaveVines)Block.get(this.hasBerries() ? 630 : 577, this.getDamage());
        this.getLevel().setBlock(this, support, true, true);
        return true;
    }

    private boolean tryGrowItself() {
        if (this.hasBerries() || ThreadLocalRandom.current().nextFloat() >= 0.132f) {
            return false;
        }
        BlockCaveVines blockCaveVines = this.getStateWithBerries(this);
        this.getLevel().setBlock(this, blockCaveVines, true, true);
        return true;
    }

    public BlockCaveVines getStateWithBerries(Position position) {
        if (this.getDamage() == 0) {
            return (BlockCaveVines)Block.get(631, 0, position);
        }
        return (BlockCaveVines)Block.get(631, this.getDamage(), position);
    }

    public BlockCaveVines getStateWithoutBerries(Position position) {
        return (BlockCaveVines)Block.get(577, this.getDamage(), position);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (!this.hasBerries()) {
            return new Item[0];
        }
        return new Item[]{Item.get(654, (Integer)0, 1)};
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId()), 0, 1);
    }

    public void setVineAge(int age) {
        this.setDamage(age);
    }

    public int getVineAge() {
        return this.getDamage();
    }

    public int getMaxAge() {
        return 25;
    }

    public boolean hasBerries() {
        return false;
    }

    @Override
    public boolean canBeClimbed() {
        return true;
    }

    public static boolean isCaveVine(Block block) {
        switch (block.getId()) {
            case 577: 
            case 630: 
            case 631: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }
}

