/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCauldronLava;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityCauldron;
import cn.nukkit.event.player.PlayerBucketEmptyEvent;
import cn.nukkit.event.player.PlayerBucketFillEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.item.ItemDye;
import cn.nukkit.level.Sound;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.particle.SmokeParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class BlockCauldron
extends BlockTransparentMeta {
    private byte freezing;

    public BlockCauldron() {
        super(0);
    }

    public BlockCauldron(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 118;
    }

    @Override
    public String getName() {
        return "Cauldron Block";
    }

    @Override
    public double getResistance() {
        return 10.0;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    public boolean isFull() {
        return (this.getDamage() & 6) == 6;
    }

    public boolean isEmpty() {
        return this.getDamage() == 0;
    }

    public int getFillLevel() {
        return (this.getDamage() & 6) >> 1;
    }

    public void setFillLevel(int fillLevel) {
        fillLevel = MathHelper.clamp(fillLevel, 0, 3);
        this.setDamage(fillLevel << 1);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockEntity be = this.level.getBlockEntity(this);
        if (!(be instanceof BlockEntityCauldron)) {
            return false;
        }
        BlockEntityCauldron cauldron = (BlockEntityCauldron)be;
        switch (item.getId()) {
            case 325: {
                if (item.getDamage() == 0) {
                    if (!this.isFull() || cauldron.isCustomColor() || cauldron.hasPotion()) break;
                    ItemBucket bucket = (ItemBucket)item.clone();
                    bucket.setCount(1);
                    bucket.setDamage(8);
                    PlayerBucketFillEvent ev = new PlayerBucketFillEvent(player, this, null, item, bucket);
                    this.level.getServer().getPluginManager().callEvent(ev);
                    if (ev.isCancelled()) break;
                    this.replaceBucket(item, player, ev.getItem());
                    this.setFillLevel(0);
                    this.level.setBlock(this, this, true);
                    cauldron.clearCustomColor();
                    this.getLevel().addSound(this, Sound.CAULDRON_TAKEWATER);
                    break;
                }
                if (item.getDamage() != 8 && item.getDamage() != 10 || this.isFull() && !cauldron.isCustomColor() && !cauldron.hasPotion() && item.getDamage() == 8) break;
                ItemBucket bucket = (ItemBucket)item.clone();
                bucket.setCount(1);
                bucket.setDamage(0);
                PlayerBucketEmptyEvent ev = new PlayerBucketEmptyEvent(player, this, null, item, bucket);
                this.level.getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) break;
                if (player.isSurvival() || player.isAdventure()) {
                    this.replaceBucket(item, player, ev.getItem());
                }
                if (cauldron.hasPotion()) {
                    this.clearWithFizz(cauldron);
                    break;
                }
                if (item.getDamage() == 8) {
                    this.setFillLevel(3);
                    cauldron.clearCustomColor();
                    this.level.setBlock(this, this, true);
                    this.getLevel().addSound(this, Sound.CAULDRON_FILLWATER);
                    break;
                }
                if (this.isEmpty()) {
                    BlockCauldronLava cauldronLava = new BlockCauldronLava(14);
                    cauldronLava.setFillLevel(3);
                    this.level.setBlock(this, cauldronLava, true, true);
                    cauldron.clearCustomColor();
                    this.getLevel().addSound(this.add(0.5, 0.5, 0.5), Sound.BUCKET_EMPTY_LAVA);
                    break;
                }
                this.clearWithFizz(cauldron);
                break;
            }
            case 351: {
                if (this.isEmpty() || cauldron.hasPotion()) break;
                if (player.isSurvival() || player.isAdventure()) {
                    --item.count;
                }
                BlockColor color = new ItemDye((Integer)item.getDamage()).getDyeColor().getColor();
                if (!cauldron.isCustomColor()) {
                    cauldron.setCustomColor(color);
                } else {
                    BlockColor current = cauldron.getCustomColor();
                    BlockColor mixed = new BlockColor(current.getRed() + (color.getRed() - current.getRed() >> 1), current.getGreen() + (color.getGreen() - current.getGreen() >> 1), current.getBlue() + (color.getBlue() - current.getBlue() >> 1));
                    cauldron.setCustomColor(mixed);
                }
                this.level.addSound(this, Sound.CAULDRON_ADDDYE);
                break;
            }
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 416: {
                if (this.isEmpty() || cauldron.hasPotion()) break;
                CompoundTag compoundTag = item.getNamedTag();
                if (compoundTag == null) {
                    compoundTag = new CompoundTag();
                }
                if (cauldron.isCustomColor()) {
                    compoundTag.putInt("customColor", cauldron.getCustomColor().getRGB());
                } else {
                    compoundTag.remove("customColor");
                }
                item.setCompoundTag(compoundTag);
                player.getInventory().setItemInHand(item);
                this.setFillLevel(this.getFillLevel() - 1);
                this.level.setBlock(this, this, true, true);
                this.level.addSound(this, Sound.CAULDRON_DYEARMOR);
                break;
            }
            case 373: 
            case 438: 
            case 441: {
                if (!this.isEmpty() && (cauldron.hasPotion() ? cauldron.getPotionId() != item.getDamage() : item.getDamage() != 0)) {
                    this.clearWithFizz(cauldron);
                    this.consumePotion(item, player);
                    break;
                }
                if (this.isFull()) break;
                if (item.getDamage() != 0 && this.isEmpty()) {
                    cauldron.setPotionId(item.getDamage());
                }
                cauldron.setPotionType(item.getId() == 373 ? 0 : (item.getId() == 438 ? 1 : 2));
                cauldron.spawnToAll();
                this.setFillLevel(this.getFillLevel() + 1);
                this.level.setBlock(this, this, true);
                this.consumePotion(item, player);
                this.getLevel().addSound(this, Sound.CAULDRON_FILLPOTION);
                break;
            }
            case 374: {
                boolean consumeBottle;
                Item potion;
                int meta;
                if (this.isEmpty()) break;
                int n = meta = cauldron.hasPotion() ? cauldron.getPotionId() : 0;
                if (meta == 0) {
                    potion = Item.get(373);
                } else {
                    switch (cauldron.getPotionType()) {
                        case 1: {
                            potion = Item.get(438, (Integer)meta);
                            break;
                        }
                        case 2: {
                            potion = Item.get(441, (Integer)meta);
                            break;
                        }
                        default: {
                            potion = Item.get(373, (Integer)meta);
                        }
                    }
                }
                this.setFillLevel(this.getFillLevel() - 1);
                if (this.isEmpty()) {
                    cauldron.setPotionId(65535);
                    cauldron.clearCustomColor();
                }
                this.level.setBlock(this, this, true);
                boolean bl = consumeBottle = player.isSurvival() || player.isAdventure();
                if (consumeBottle && item.getCount() == 1) {
                    player.getInventory().setItemInHand(potion);
                } else if (item.getCount() > 1) {
                    if (consumeBottle) {
                        --item.count;
                    }
                    if (player.getInventory().canAddItem(potion)) {
                        player.getInventory().addItem(potion);
                    } else {
                        player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), potion, player.getDirectionVector().multiply(0.4));
                    }
                }
                this.getLevel().addSound(this, Sound.CAULDRON_TAKEPOTION);
                break;
            }
            case 262: {
                if (item.getDamage() > 1 || !cauldron.hasPotion()) break;
                if (!player.isCreative() && item.getCount() == 1) {
                    item.setDamage(BlockCauldron.potion2arrow(cauldron.getPotionId()));
                    player.getInventory().setItemInHand(item);
                } else if (item.getCount() > 1) {
                    Item newItem = item.clone();
                    newItem.setCount(1);
                    newItem.setDamage(BlockCauldron.potion2arrow(cauldron.getPotionId()));
                    if (!player.isCreative()) {
                        --item.count;
                    }
                    if (player.getInventory().canAddItem(newItem)) {
                        player.getInventory().addItem(newItem);
                    } else {
                        player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), newItem, player.getDirectionVector().multiply(0.4));
                    }
                }
                this.setFillLevel(this.getFillLevel() - 1);
                if (this.isEmpty()) {
                    cauldron.setPotionId(65535);
                    cauldron.clearCustomColor();
                }
                this.level.setBlock(this, this, true);
                this.level.addLevelEvent(this.add(0.5, 0.375 + (double)this.getDamage() * 0.125, 0.5), 3502);
            }
            case 218: {
                if (this.isEmpty() || cauldron.isCustomColor() || cauldron.hasPotion()) break;
                player.getInventory().setItemInHand(Item.get(205).setCompoundTag(item.getCompoundTag()));
                this.setFillLevel(this.getFillLevel() - 1);
                this.level.setBlock(this, this, true);
                this.getLevel().addSound(this, Sound.CAULDRON_TAKEPOTION);
                break;
            }
            default: {
                return true;
            }
        }
        this.level.updateComparatorOutputLevel(this);
        return true;
    }

    private static int potion2arrow(int potion) {
        int id = potion & 0xFFFF;
        if (id < 5 || id > 43) {
            return 1;
        }
        return id < 43 ? id + 1 : id;
    }

    protected void replaceBucket(Item oldBucket, Player player, Item newBucket) {
        if (player.isSurvival() || player.isAdventure()) {
            if (oldBucket.getCount() == 1) {
                player.getInventory().setItemInHand(newBucket);
            } else {
                oldBucket.setCount(oldBucket.getCount() - 1);
                if (player.getInventory().canAddItem(newBucket)) {
                    player.getInventory().addItem(newBucket);
                } else {
                    player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), newBucket, player.getDirectionVector().multiply(0.4));
                }
            }
        }
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        CompoundTag nbt = new CompoundTag("").putString("id", "Cauldron").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("PotionId", 65535).putByte("SplashPotion", 0);
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        BlockEntity.createBlockEntity("Cauldron", this.getChunk(), nbt, new Object[0]);
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.getTier() >= 1) {
            return new Item[]{Item.get(380)};
        }
        return new Item[0];
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2 && this.level.isRaining() && !this.isFull()) {
            if (this.freezing < 1) {
                this.freezing = (byte)(Biome.getBiome(this.level.getBiomeId((int)this.x, (int)this.z)).isFreezing() ? 2 : 1);
            }
            if (this.freezing == 1 && ThreadLocalRandom.current().nextInt(20) == 0 && this.level.canBlockSeeSky(this)) {
                this.setFillLevel(this.getFillLevel() + 1);
                this.getLevel().setBlock(this, this, true, true);
                return 2;
            }
        }
        return super.onUpdate(type);
    }

    @Override
    public Item toItem() {
        return Item.get(380);
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.getFillLevel();
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    private void consumePotion(Item item, Player player) {
        if (player.isSurvival() || player.isAdventure()) {
            if (item.getCount() == 1) {
                player.getInventory().setItemInHand(new ItemBlock(Block.get(0)));
            } else if (item.getCount() > 1) {
                --item.count;
                Item bottle = Item.get(374);
                if (player.getInventory().canAddItem(bottle)) {
                    player.getInventory().addItem(bottle);
                } else {
                    player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), bottle, player.getDirectionVector().multiply(0.4));
                }
            }
        }
    }

    public void clearWithFizz(BlockEntityCauldron cauldron) {
        this.setFillLevel(0);
        cauldron.setPotionId(65535);
        cauldron.setSplashPotion(false);
        cauldron.clearCustomColor();
        this.level.setBlock(this, Block.get(118), true);
        this.level.addLevelSoundEvent(this, 27);
        this.getLevel().addParticle(new SmokeParticle(this.add(Math.random(), 1.2, Math.random())), null, 8);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GRAY_BLOCK_COLOR;
    }
}

