/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.item.food.Food;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;

public class BlockCake
extends BlockTransparentMeta {
    public BlockCake(int meta) {
        super(meta);
    }

    public BlockCake() {
        this(0);
    }

    @Override
    public String getName() {
        return "Cake Block";
    }

    @Override
    public int getId() {
        return 92;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 0.5;
    }

    @Override
    public double getMinX() {
        return this.x + (double)(1 + (this.getDamage() << 1) >> 4);
    }

    @Override
    public double getMinZ() {
        return this.z + 0.0625;
    }

    @Override
    public double getMaxX() {
        return this.x - 0.0625 + 1.0;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.5;
    }

    @Override
    public double getMaxZ() {
        return this.z - 0.0625 + 1.0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (this.down().getId() != 0) {
            this.getLevel().setBlock(this, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().getId() == 0) {
            this.getLevel().setBlock(this, Block.get(0), true);
            return 1;
        }
        return 0;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return Item.get(354);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null && player.canEat(false)) {
            if (this.getDamage() <= 6) {
                this.setDamage(this.getDamage() + 1);
            }
            if (this.getDamage() >= 6) {
                this.getLevel().setBlock(this, Block.get(0), true);
            } else {
                Food.getByRelative(this).eatenBy(player);
                this.getLevel().setBlock(this, this, true);
            }
            player.getLevel().addLevelSoundEvent(player, 89);
            return true;
        }
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public int getComparatorInputOverride() {
        return 7 - this.getDamage() << 1;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

