/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLayer;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;

public class BlockCactus
extends BlockTransparentMeta {
    public BlockCactus(int meta) {
        super(meta);
    }

    public BlockCactus() {
        this(0);
    }

    @Override
    public int getId() {
        return 81;
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.9375;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.CONTACT, 1.0f));
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block down = this.down();
            if (down.getId() != 12 && down.getId() != 81) {
                this.getLevel().useBreakOn(this);
            } else {
                for (BlockFace side : BlockFace.Plane.HORIZONTAL) {
                    if (this.getSide(side).canBeFlowedInto()) continue;
                    this.getLevel().useBreakOn(this);
                }
            }
        } else if (type == 2 && this.down().getId() != 81) {
            if (this.getDamage() == 15) {
                BaseFullChunk chunk = this.level.getChunk((int)this.x >> 4, (int)this.z >> 4);
                for (int y = 1; y < 3; ++y) {
                    Block b = this.getLevel().getBlock(chunk, (int)this.x, (int)this.y + y, (int)this.z, true);
                    if (b.getId() != 0) continue;
                    BlockGrowEvent event = new BlockGrowEvent(b, Block.get(81));
                    Server.getInstance().getPluginManager().callEvent(event);
                    if (event.isCancelled()) break;
                    this.getLevel().setBlock(b, event.getNewState(), true, true);
                    break;
                }
                this.setDamage(0);
            } else {
                this.setDamage(this.getDamage() + 1);
            }
            this.level.setBlock((int)this.x, (int)this.y, (int)this.z, BlockLayer.NORMAL, this, false, true, false);
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        if (down.getId() == 12 || down.getId() == 81) {
            Block block0 = this.north();
            Block block1 = this.south();
            Block block2 = this.west();
            Block block3 = this.east();
            if (block0.canBeFlowedInto() && block1.canBeFlowedInto() && block2.canBeFlowedInto() && block3.canBeFlowedInto()) {
                this.getLevel().setBlock(this, this, true, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "Cactus";
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{Item.get(81, (Integer)0, 1)};
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

