/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.Faceable;

public abstract class BlockButton
extends BlockFlowable
implements Faceable {
    public BlockButton() {
        this(0);
    }

    public BlockButton(int meta) {
        super(meta);
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setDamage(face.getIndex());
        if (!this.isSupportValid(this.getSide(this.getFacing().getOpposite()))) {
            return false;
        }
        this.getLevel().setBlock(this, this, true, true);
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (this.isActivated()) {
            return false;
        }
        this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 0, 15));
        this.setDamage(this.getDamage() ^ 8);
        this.level.setBlock(this, this, true, false);
        this.level.addLevelSoundEvent(this, 73);
        this.level.scheduleUpdate(this, 30);
        this.level.updateAroundRedstone(this, null);
        this.level.updateAroundRedstone(this.getSideVec(this.getFacing().getOpposite()), null);
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.isSupportValid(this.getSide(this.getFacing().getOpposite()))) {
                this.level.useBreakOn(this, Item.get(270));
                return 1;
            }
        } else if (type == 3) {
            if (this.isActivated()) {
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
                this.setDamage(this.getDamage() ^ 8);
                this.level.setBlock(this, this, true, false);
                this.level.addLevelSoundEvent(this, 74);
                this.level.updateAroundRedstone(this, null);
                this.level.updateAroundRedstone(this.getSideVec(this.getFacing().getOpposite()), null);
            }
            return 3;
        }
        return 0;
    }

    private boolean isSupportValid(Block block) {
        if (!block.isTransparent()) {
            return true;
        }
        if (this.getFacing() == BlockFace.UP) {
            return Block.canStayOnFullSolid(block);
        }
        return Block.canConnectToFullSolid(block);
    }

    public boolean isActivated() {
        return (this.getDamage() & 8) == 8;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.isActivated() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.isActivated() ? 0 : (this.getFacing() == side ? 15 : 0);
    }

    public BlockFace getFacing() {
        int side = this.isActivated() ? this.getDamage() ^ 8 : this.getDamage();
        return BlockFace.fromIndex(side);
    }

    @Override
    public boolean onBreak(Item item) {
        if (this.isActivated()) {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
        }
        return super.onBreak(item);
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

