/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAmethystBud;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.event.block.BlockSpreadEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockBuddingAmethyst
extends BlockSolid {
    @Override
    public int getId() {
        return 583;
    }

    @Override
    public double getResistance() {
        return 1.5;
    }

    @Override
    public double getHardness() {
        return 1.5;
    }

    @Override
    public String getName() {
        return "Budding Amethyst";
    }

    @Override
    public int onUpdate(int type) {
        if (type != 2 || ThreadLocalRandom.current().nextInt(4) != 0) {
            return type;
        }
        BlockFace face = BlockFace.values()[ThreadLocalRandom.current().nextInt(BlockFace.values().length)];
        Block block = this.getSide(face);
        BlockAmethystBud targetBlock = null;
        if (block.getId() == 0 || Block.isWater(block.getId()) && block.getDamage() == 8) {
            targetBlock = (BlockAmethystBud)Block.get(587);
        } else if (block.getId() == 587 && ((BlockAmethystBud)block).getBlockFace() == face) {
            targetBlock = (BlockAmethystBud)Block.get(586);
        } else if (block.getId() == 586 && ((BlockAmethystBud)block).getBlockFace() == face) {
            targetBlock = (BlockAmethystBud)Block.get(585);
        } else if (block.getId() == 585 && ((BlockAmethystBud)block).getBlockFace() == face) {
            targetBlock = (BlockAmethystBud)Block.get(584);
        }
        if (targetBlock != null) {
            targetBlock.setBlockFace(face);
            BlockSpreadEvent event = new BlockSpreadEvent(block, this, targetBlock);
            this.getLevel().getServer().getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                this.getLevel().setBlock(block, event.getNewState(), false, true);
            }
        }
        return type;
    }

    @Override
    public boolean onBreak(Item item, Player player) {
        for (BlockFace face : BlockFace.values()) {
            Block side = this.getSide(face);
            if (!(side instanceof BlockAmethystBud) || ((BlockAmethystBud)side).getBlockFace() != face) continue;
            this.getLevel().setBlock(side, Block.get(0), true, true);
            this.getLevel().addParticle(new DestroyBlockParticle(side.add(0.5), side));
        }
        return super.onBreak(item, player);
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.PURPLE_BLOCK_COLOR;
    }
}

