/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFurnaceBurning;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBlastFurnace;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import java.util.Map;

public class BlockBlastFurnaceLit
extends BlockFurnaceBurning {
    public BlockBlastFurnaceLit() {
        this(0);
    }

    public BlockBlastFurnaceLit(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Lit Blast Furnace";
    }

    @Override
    public int getId() {
        return 469;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(451));
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        BlockEntityBlastFurnace furnace;
        this.setDamage(Block.FACES2534[player != null ? player.getDirection().getHorizontalIndex() : 0]);
        this.getLevel().setBlock(block, this, true, true);
        CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", "BlastFurnace").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        return (furnace = (BlockEntityBlastFurnace)BlockEntity.createBlockEntity("BlastFurnace", this.getChunk(), nbt, new Object[0])) != null;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            BlockEntity t2 = this.getLevel().getBlockEntity(this);
            if (!(t2 instanceof BlockEntityBlastFurnace)) {
                return false;
            }
            BlockEntityBlastFurnace furnace = (BlockEntityBlastFurnace)t2;
            if (furnace.namedTag.contains("Lock") && furnace.namedTag.get("Lock") instanceof StringTag && !furnace.namedTag.getString("Lock").equals(item.getCustomName())) {
                return true;
            }
            player.addWindow(furnace.getInventory());
        }
        return true;
    }
}

