/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.block.BlockFence;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBell;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.event.block.BellRingEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockBell
extends BlockTransparentMeta
implements Faceable {
    public static final int TYPE_ATTACHMENT_STANDING = 0;
    public static final int TYPE_ATTACHMENT_HANGING = 1;
    public static final int TYPE_ATTACHMENT_SIDE = 2;
    public static final int TYPE_ATTACHMENT_MULTIPLE = 3;

    public BlockBell() {
        this(0);
    }

    public BlockBell(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Bell";
    }

    @Override
    public int getId() {
        return 461;
    }

    private boolean isConnectedTo(BlockFace connectedFace, int attachmentType, BlockFace blockFace) {
        BlockFace.Axis faceAxis = connectedFace.getAxis();
        switch (attachmentType) {
            case 0: {
                if (faceAxis == BlockFace.Axis.Y) {
                    return connectedFace == BlockFace.DOWN;
                }
                return blockFace.getAxis() != faceAxis;
            }
            case 1: {
                return connectedFace == BlockFace.UP;
            }
            case 2: {
                return connectedFace == blockFace.getOpposite();
            }
            case 3: {
                return connectedFace == blockFace || connectedFace == blockFace.getOpposite();
            }
        }
        return false;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        int attachmentType = this.getAttachmentType();
        BlockFace blockFace = this.getBlockFace();
        boolean north = this.isConnectedTo(BlockFace.NORTH, attachmentType, blockFace);
        boolean south = this.isConnectedTo(BlockFace.SOUTH, attachmentType, blockFace);
        boolean west = this.isConnectedTo(BlockFace.WEST, attachmentType, blockFace);
        boolean east = this.isConnectedTo(BlockFace.EAST, attachmentType, blockFace);
        boolean up = this.isConnectedTo(BlockFace.UP, attachmentType, blockFace);
        boolean down = this.isConnectedTo(BlockFace.DOWN, attachmentType, blockFace);
        double n = north ? 0.0 : 0.25;
        double s2 = south ? 1.0 : 0.75;
        double w = west ? 0.0 : 0.25;
        double e = east ? 1.0 : 0.75;
        double d = down ? 0.0 : 0.25;
        double u = up ? 1.0 : 0.75;
        return new SimpleAxisAlignedBB(this.x + w, this.y + d, this.z + n, this.x + e, this.y + u, this.z + s2);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        AxisAlignedBB blockBoundingBox;
        AxisAlignedBB boundingBox;
        if (entity instanceof EntityItem && entity.getMotion().lengthSquared() > 0.01 && (boundingBox = entity.getBoundingBox()).intersectsWith(blockBoundingBox = this.getCollisionBoundingBox())) {
            Vector3 entityCenter = new Vector3((boundingBox.getMaxX() - boundingBox.getMinX()) / 2.0, (boundingBox.getMaxY() - boundingBox.getMinY()) / 2.0, (boundingBox.getMaxZ() - boundingBox.getMinZ()) / 2.0);
            Vector3 blockCenter = new Vector3((blockBoundingBox.getMaxX() - blockBoundingBox.getMinX()) / 2.0, (blockBoundingBox.getMaxY() - blockBoundingBox.getMinY()) / 2.0, (blockBoundingBox.getMaxZ() - blockBoundingBox.getMinZ()) / 2.0);
            Location entityPos = entity.add(entityCenter);
            Position blockPos = this.add(blockBoundingBox.getMinX() - this.x + blockCenter.x, blockBoundingBox.getMinY() - this.y + blockCenter.y, blockBoundingBox.getMinZ() - this.z + blockCenter.z);
            Vector3 entityVector = ((Vector3)entityPos).subtract(blockPos);
            entityVector = entityVector.normalize().multiply(0.4);
            entityVector.y = Math.max(0.15, entityVector.y);
            if (this.ring(entity, BellRingEvent.RingCause.DROPPED_ITEM)) {
                entity.setMotion(entityVector);
            }
        }
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return this.recalculateBoundingBox().expand(1.0E-6, 1.0E-6, 1.0E-6);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        return this.ring(player, player != null ? BellRingEvent.RingCause.HUMAN_INTERACTION : BellRingEvent.RingCause.UNKNOWN);
    }

    public boolean ring(Entity causeEntity, BellRingEvent.RingCause cause) {
        return this.ring(causeEntity, cause, null);
    }

    public boolean ring(Entity causeEntity, BellRingEvent.RingCause cause, BlockFace hitFace) {
        BlockEntityBell bell = this.getOrCreateBlockEntity();
        if (bell == null) {
            return true;
        }
        boolean addException = true;
        BlockFace blockFace = this.getBlockFace();
        if (hitFace == null) {
            if (causeEntity != null) {
                if (causeEntity instanceof EntityItem) {
                    int z;
                    int x;
                    Position blockMid = this.add(0.5, 0.5, 0.5);
                    Vector3 vector = causeEntity.subtract(blockMid).normalize();
                    int n = vector.x < 0.0 ? -1 : (x = vector.x > 0.0 ? 1 : 0);
                    int n2 = vector.z < 0.0 ? -1 : (z = vector.z > 0.0 ? 1 : 0);
                    if (x != 0 && z != 0) {
                        if (Math.abs(vector.x) < Math.abs(vector.z)) {
                            x = 0;
                        } else {
                            z = 0;
                        }
                    }
                    hitFace = blockFace;
                    for (BlockFace face : BlockFace.values()) {
                        if (face.getXOffset() != x || face.getZOffset() != z) continue;
                        hitFace = face;
                        break;
                    }
                } else {
                    hitFace = causeEntity.getDirection();
                }
            } else {
                hitFace = blockFace;
            }
        }
        switch (this.getAttachmentType()) {
            case 0: {
                if (hitFace.getAxis() == blockFace.getAxis()) break;
                return false;
            }
            case 3: {
                if (hitFace.getAxis() != blockFace.getAxis()) break;
                return false;
            }
            case 2: {
                if (hitFace.getAxis() != blockFace.getAxis()) break;
                addException = false;
            }
        }
        BellRingEvent event = new BellRingEvent(this, cause, causeEntity);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        bell.setDirection(hitFace.getOpposite().getHorizontalIndex());
        bell.setTicks(0);
        bell.setRinging(true);
        if (addException && causeEntity instanceof Player) {
            bell.spawnExceptions.add(causeEntity.getId());
        }
        this.level.addLevelSoundEvent(this, 258);
        return true;
    }

    private boolean checkSupport() {
        switch (this.getAttachmentType()) {
            case 0: {
                if (!this.checkSupport(this.down(), BlockFace.UP)) break;
                return true;
            }
            case 1: {
                if (!this.checkSupport(this.up(), BlockFace.DOWN)) break;
                return true;
            }
            case 3: {
                BlockFace blockFace = this.getBlockFace();
                if (!this.checkSupport(this.getSide(blockFace), blockFace.getOpposite()) || !this.checkSupport(this.getSide(blockFace.getOpposite()), blockFace)) break;
                return true;
            }
            case 2: {
                BlockFace blockFace = this.getBlockFace();
                if (!this.checkSupport(this.getSide(blockFace.getOpposite()), blockFace)) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkSupport(Block support, BlockFace attachmentFace) {
        if (!support.isTransparent()) {
            return true;
        }
        if (attachmentFace == BlockFace.DOWN) {
            switch (support.getId()) {
                case 101: 
                case 154: {
                    return true;
                }
            }
            return support instanceof BlockFence;
        }
        if (support instanceof BlockCauldron) {
            return attachmentFace == BlockFace.UP;
        }
        if (attachmentFace == BlockFace.UP) {
            return Block.canStayOnFullSolid(support);
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.checkSupport()) {
                this.level.useBreakOn(this);
            }
            return type;
        }
        if (type == 6) {
            if (this.level.isBlockPowered(this)) {
                if (!this.isToggled()) {
                    this.setToggled(true);
                    this.level.setBlock(this, this, true, true);
                    this.ring(null, BellRingEvent.RingCause.REDSTONE);
                }
            } else if (this.isToggled()) {
                this.setToggled(false);
                this.level.setBlock(this, this, true, true);
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (block.canBeReplaced() && block.getId() != 0 && !(block instanceof BlockLiquid)) {
            face = BlockFace.UP;
        }
        switch (face) {
            case UP: {
                this.setAttachmentType(0);
                this.setBlockFace(player.getDirection().getOpposite());
                break;
            }
            case DOWN: {
                this.setAttachmentType(1);
                this.setBlockFace(player.getDirection().getOpposite());
                break;
            }
            default: {
                this.setBlockFace(face);
                if (this.checkSupport(block.getSide(face), face.getOpposite())) {
                    this.setAttachmentType(3);
                    break;
                }
                this.setAttachmentType(2);
            }
        }
        if (!this.checkSupport()) {
            return false;
        }
        this.getLevel().setBlock(this, this, true, true);
        this.createBlockEntity();
        return true;
    }

    private BlockEntityBell createBlockEntity() {
        CompoundTag nbt = BlockEntity.getDefaultCompound(this, "Bell");
        return (BlockEntityBell)BlockEntity.createBlockEntity("Bell", this.getChunk(), nbt, new Object[0]);
    }

    private BlockEntityBell getOrCreateBlockEntity() {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (!(blockEntity instanceof BlockEntityBell)) {
            blockEntity = this.createBlockEntity();
        }
        return (BlockEntityBell)blockEntity;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 3);
    }

    public void setBlockFace(BlockFace face) {
        if (face.getHorizontalIndex() == -1) {
            return;
        }
        this.setDamage(this.getDamage() & 0x3C | face.getHorizontalIndex());
    }

    public int getAttachmentType() {
        return (this.getDamage() & 0xC) >> 2 & 3;
    }

    public void setAttachmentType(int attachmentType) {
        this.setDamage(this.getDamage() & 0x33 | (attachmentType &= 3) << 2);
    }

    public boolean isToggled() {
        return (this.getDamage() & 0x10) == 16;
    }

    public void setToggled(boolean toggled) {
        this.setDamage(this.getDamage() & 0x2F | (toggled ? 16 : 0));
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public double getHardness() {
        return 5.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GOLD_BLOCK_COLOR;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

