/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBed;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.player.PlayerBedEnterEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Explosion;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Faceable;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;

public class BlockBed
extends BlockTransparentMeta
implements Faceable {
    private static final IntSet MOB_IDS = new IntOpenHashSet(new int[]{43, 40, 33, 110, 50, 38, 55, 104, 41, 49, 124, 47, 127, 114, 59, 54, 39, 34, 37, 35, 46, 105, 57, 45, 52, 48, 126, 32, 36, 44, 116});
    public boolean canDropItem = true;

    public BlockBed() {
        this(0);
    }

    public BlockBed(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 26;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public String getName() {
        return this.getDyeColor().getName() + " Bed Block";
    }

    @Override
    public double getMaxY() {
        return this.y + 0.5625;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        Block b;
        if (this.level.getDimension() != 0) {
            if (this.level.getGameRules().getBoolean(GameRule.RESPAWN_BLOCKS_EXPLODE)) {
                if (this.getLevel().setBlock(this, Block.get(0), true, true)) {
                    this.level.addParticle(new DestroyBlockParticle(this.add(0.5, 0.5, 0.5), this));
                }
                Explosion explosion = new Explosion(this.add(0.5, 0.0, 0.5), 5.0, this);
                explosion.explodeA();
                explosion.explodeB();
            }
            return true;
        }
        Block blockNorth = this.north();
        Block blockSouth = this.south();
        Block blockEast = this.east();
        Block blockWest = this.west();
        if ((this.getDamage() & 8) == 8) {
            b = this;
        } else if (blockNorth.getId() == 26 && (blockNorth.getDamage() & 8) == 8) {
            b = blockNorth;
        } else if (blockSouth.getId() == 26 && (blockSouth.getDamage() & 8) == 8) {
            b = blockSouth;
        } else if (blockEast.getId() == 26 && (blockEast.getDamage() & 8) == 8) {
            b = blockEast;
        } else if (blockWest.getId() == 26 && (blockWest.getDamage() & 8) == 8) {
            b = blockWest;
        } else {
            if (player != null) {
                player.sendMessage("\u00a77%tile.bed.notValid", true);
            }
            return true;
        }
        if (player != null) {
            int time;
            boolean isNight;
            if (player.distanceSquared(this) > 36.0) {
                player.sendMessage("\u00a77%tile.bed.tooFar", true);
                return true;
            }
            if (!player.isCreative()) {
                BlockFace secondPart = this.getBlockFace().getOpposite();
                AxisAlignedBB checkArea = new SimpleAxisAlignedBB(b.x - 8.0, b.y - 6.5, b.z - 8.0, b.x + 9.0, b.y + 5.5, b.z + 9.0).addCoord(secondPart.getXOffset(), 0.0, secondPart.getZOffset());
                for (Entity entity : this.getLevel().getCollidingEntities(checkArea)) {
                    if (entity.isClosed() || !MOB_IDS.contains(entity.getNetworkId())) continue;
                    player.sendMessage("\u00a77%tile.bed.notSafe", true);
                    return true;
                }
            }
            boolean bl = isNight = (time = this.getLevel().getTime() % 24000) >= 14000 && time < 23000;
            if (!isNight && !this.getLevel().isThundering()) {
                if (!b.equals(player.getSpawnPosition())) {
                    PlayerBedEnterEvent ev = new PlayerBedEnterEvent(player, this, true);
                    player.getServer().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        player.setSpawn(b);
                        player.sendMessage("\u00a77%tile.bed.respawnSet", true);
                    }
                }
                player.sendMessage("\u00a77%tile.bed.noSleep", true);
            } else if (!player.sleepOn(b)) {
                player.sendMessage("\u00a77%tile.bed.occupied", true);
            }
        }
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block next;
        if (BlockBed.canStayOnFullNonSolid(this.down()) && (next = this.getSide(player.getHorizontalFacing())).canBeReplaced() && BlockBed.canStayOnFullNonSolid(next.down())) {
            int meta = player.getDirection().getHorizontalIndex();
            this.getLevel().setBlock(block, Block.get(26, meta), true, true);
            this.getLevel().setBlock(next, Block.get(26, meta | 8), true, true);
            this.createBlockEntity(this, item.getDamage());
            this.createBlockEntity(next, item.getDamage());
            return true;
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        Block blockNorth = this.north();
        Block blockSouth = this.south();
        Block blockEast = this.east();
        Block blockWest = this.west();
        Block secondPart = null;
        if ((this.getDamage() & 8) == 8) {
            if (blockNorth.getId() == 26 && (blockNorth.getDamage() & 8) != 8) {
                secondPart = blockNorth;
            } else if (blockSouth.getId() == 26 && (blockSouth.getDamage() & 8) != 8) {
                secondPart = blockSouth;
            } else if (blockEast.getId() == 26 && (blockEast.getDamage() & 8) != 8) {
                secondPart = blockEast;
            } else if (blockWest.getId() == 26 && (blockWest.getDamage() & 8) != 8) {
                secondPart = blockWest;
            }
        } else if (blockNorth.getId() == 26 && (blockNorth.getDamage() & 8) == 8) {
            secondPart = blockNorth;
        } else if (blockSouth.getId() == 26 && (blockSouth.getDamage() & 8) == 8) {
            secondPart = blockSouth;
        } else if (blockEast.getId() == 26 && (blockEast.getDamage() & 8) == 8) {
            secondPart = blockEast;
        } else if (blockWest.getId() == 26 && (blockWest.getDamage() & 8) == 8) {
            secondPart = blockWest;
        }
        if (secondPart != null) {
            Entity[] secondPartDrop;
            Entity[] entityArray = secondPartDrop = (secondPart.getDamage() & 8) == 8 ? secondPart.toItem() : null;
            if (this.getLevel().setBlock(secondPart, Block.get(0), true, true) && secondPartDrop != null && this.canDropItem && this.getLevel().gameRules.getBoolean(GameRule.DO_TILE_DROPS)) {
                this.getLevel().dropItem(this.add(0.5, 0.5, 0.5), (Item)secondPartDrop);
            }
        }
        this.getLevel().setBlock(this, Block.get(0), true, secondPart == null);
        for (Entity entity : this.level.getNearbyEntities(new SimpleAxisAlignedBB(this, this).grow(2.0, 1.0, 2.0))) {
            Player player;
            if (!(entity instanceof Player) || (player = (Player)entity).getSleepingPos() == null || !player.getSleepingPos().equals(this) && !player.getSleepingPos().equals(secondPart)) continue;
            player.stopSleep();
        }
        if (this.level.getDimension() == 0) {
            Position safeSpawn = null;
            for (Player player : this.level.getServer().getOnlinePlayers().values()) {
                if (player.getSpawnPosition() == null || !player.getSpawnPosition().equals(this) && !player.getSpawnPosition().equals(secondPart)) continue;
                player.setSpawn(safeSpawn == null ? this.level.getServer().getDefaultLevel().getSafeSpawn() : safeSpawn);
            }
        }
        return true;
    }

    private void createBlockEntity(Block pos, int color) {
        CompoundTag nbt = BlockEntity.getDefaultCompound(pos, "Bed");
        nbt.putByte("color", color);
        BlockEntityBed be = (BlockEntityBed)BlockEntity.createBlockEntity("Bed", pos.getChunk(), nbt, new Object[0]);
        be.spawnToAll();
    }

    @Override
    public Item toItem() {
        return Item.get(355, (Integer)this.getDyeColor().getWoolData());
    }

    @Override
    public BlockColor getColor() {
        return this.getDyeColor().getColor();
    }

    public DyeColor getDyeColor() {
        BlockEntity blockEntity;
        if (this.level != null && (blockEntity = this.level.getBlockEntity(this)) instanceof BlockEntityBed) {
            return ((BlockEntityBed)blockEntity).getDyeColor();
        }
        return DyeColor.WHITE;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

