/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;

public class BlockBasalt
extends BlockSolidMeta {
    public BlockBasalt() {
        this(0);
    }

    public BlockBasalt(int meta) {
        super(meta);
    }

    @Override
    public double getHardness() {
        return 1.25;
    }

    @Override
    public double getResistance() {
        return 4.2;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setPillarAxis(face.getAxis());
        this.getLevel().setBlock(block, this, true, true);
        return true;
    }

    public void setPillarAxis(BlockFace.Axis axis) {
        switch (axis) {
            case Y: {
                this.setDamage(0);
                break;
            }
            case X: {
                this.setDamage(1);
                break;
            }
            case Z: {
                this.setDamage(2);
            }
        }
    }

    public BlockFace.Axis getPillarAxis() {
        switch (this.getDamage() % 3) {
            case 2: {
                return BlockFace.Axis.Z;
            }
            case 1: {
                return BlockFace.Axis.X;
            }
        }
        return BlockFace.Axis.Y;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        return "Basalt";
    }

    @Override
    public int getId() {
        return 489;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe()) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GRAY_BLOCK_COLOR;
    }
}

