/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBanner;
import cn.nukkit.item.Item;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Faceable;

public class BlockBanner
extends BlockTransparentMeta
implements Faceable {
    public BlockBanner() {
        this(0);
    }

    public BlockBanner(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 176;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public String getName() {
        return "Banner";
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (face != BlockFace.DOWN) {
            Tag patterns;
            if (face == BlockFace.UP) {
                this.setDamage(NukkitMath.floorDouble((player.yaw + 180.0) * 16.0 / 360.0 + 0.5) & 0xF);
                this.getLevel().setBlock(block, this, true);
            } else if (target.canBeReplaced()) {
                this.setDamage(NukkitMath.floorDouble((player.yaw + 180.0) * 16.0 / 360.0 + 0.5) & 0xF);
                this.getLevel().setBlock(target, this, true);
            } else {
                this.setDamage(face.getIndex());
                this.getLevel().setBlock(block, Block.get(177, this.getDamage()), true);
            }
            CompoundTag nbt = BlockEntity.getDefaultCompound(this, "Banner").putInt("Base", item.getDamage() & 0xF);
            Tag type = item.getNamedTagEntry("Type");
            if (type instanceof IntTag) {
                nbt.put("Type", type);
            }
            if ((patterns = item.getNamedTagEntry("Patterns")) instanceof ListTag) {
                nbt.put("Patterns", patterns);
            }
            BlockEntity.createBlockEntity("Banner", this.getChunk(), nbt, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().getId() == 0) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        Item item = Item.get(446);
        if (blockEntity instanceof BlockEntityBanner) {
            ListTag<CompoundTag> patterns;
            BlockEntityBanner banner = (BlockEntityBanner)blockEntity;
            item.setDamage(banner.getBaseColor() & 0xF);
            int type = banner.namedTag.getInt("Type");
            if (type > 0) {
                item.setNamedTag((item.hasCompoundTag() ? item.getNamedTag() : new CompoundTag()).putInt("Type", type));
            }
            if ((patterns = banner.namedTag.getList("Patterns", CompoundTag.class)).size() > 0) {
                item.setNamedTag((item.hasCompoundTag() ? item.getNamedTag() : new CompoundTag()).putList(patterns));
            }
        }
        return item;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public BlockColor getColor() {
        return this.getDyeColor().getColor();
    }

    public DyeColor getDyeColor() {
        BlockEntity blockEntity;
        if (this.level != null && (blockEntity = this.level.getBlockEntity(this)) instanceof BlockEntityBanner) {
            return ((BlockEntityBanner)blockEntity).getDyeColor();
        }
        return DyeColor.WHITE;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public Block.WaterloggingType getWaterloggingType() {
        return Block.WaterloggingType.WHEN_PLACED_IN_WATER;
    }

    @Override
    public boolean breakWhenPushed() {
        return true;
    }
}

