/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLeaves;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import java.util.concurrent.ThreadLocalRandom;

public class BlockAzaleaLeaves
extends BlockLeaves {
    public BlockAzaleaLeaves() {
        this(0);
    }

    public BlockAzaleaLeaves(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 579;
    }

    @Override
    public String getName() {
        return "Azalea Leaves";
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setPersistent(true);
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(this.getId(), 0), 0);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears() || item.hasEnchantment(16)) {
            return new Item[]{this.toItem()};
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (random.nextInt(20) != 0) {
            return new Item[0];
        }
        int chance = random.nextInt(4);
        if (chance == 0 || chance == 1) {
            return new Item[]{Item.get(random.nextBoolean() ? 592 : 593, (Integer)0, 1)};
        }
        if (chance == 2) {
            return new Item[]{Item.get(6, (Integer)random.nextInt(0, 6), 1)};
        }
        return new Item[]{Item.get(280, (Integer)0, random.nextInt(1, 2))};
    }

    @Override
    protected boolean canDropApple() {
        return false;
    }

    @Override
    public boolean isPersistent() {
        return (this.getDamage() & 2) >>> 1 == 1;
    }

    @Override
    public void setPersistent(boolean persistent) {
        int value = (persistent ? 1 : 0) << 1;
        this.setDamage(this.getDamage() & 0xFFFFFFFE | value & 2);
    }

    @Override
    public boolean isCheckDecay() {
        return (this.getDamage() & 1) == 1;
    }

    @Override
    public void setCheckDecay(boolean updateBit) {
        this.setDamage(this.getDamage() & 0xFFFFFFFE | (updateBit ? 1 : 0) & 1);
    }
}

